// Includes
// ----------------------------------------------------------------

#include "global.h"
#include "robot.h"

void PrintMenu(void);

// Main Program
// ----------------------------------------------------------------
int main() {  
    int mode;
    InitRobot();

    while (1) {
        PrintMenu();
        mode = pc.getc();
        pc.printf("\r\n\r\n");
        if (mode == 'a') {
            AutoTrack();
        } else if (mode == 'm') {
            ManualControl();
        } else if (mode == 't') {
            Tunning();
        } else {
            pc.printf("Error: Invalid Selection \r\n\r\n");
        }
        wait_ms(2000);
    }
}

// Other Functions
// ----------------------------------------------------------------
void PrintMenu(){
    pc.printf("\e[1;1H\e[2J");
    pc.printf("Select Mode: \r\n\r\n");
    
    pc.printf("---------------------------------------------------------------- \r\n");
    pc.printf("a. Automated Tracking \r\n");
    pc.printf("m. Manual Control \r\n");
    pc.printf("t. System Tuning \r\n");
    pc.printf("---------------------------------------------------------------- \r\n\r\n");
    
    pc.printf("=> ");
}
