#include "mbed.h"
#include "rtos.h"
#include "Pixy.h"
#include "PeriodicPI.h"

// ----------------------------------------------------------------
// Contains common defintions share between modes
// ----------------------------------------------------------------


// Preprocessor Definitions
// ----------------------------------------------------------------
#define SPEED_MAX 2 // rads/s
#define MAX_BLOCKS 1
#define X_SETPOINT 160
#define HEIGHT_SETPOINT 120
#define TARGET_DECIMAL 1 

// #define DEBUG 1

#define PWM_PERIOD 0.001
#define MOTOR_PERIOD 0.01
#define NAVIGATION_PERIOD 0.0167 // 60 times/sec

#define MOTOR_KP 0.0001 // 0.0001
#define MOTOR_KI 0.0005 // 0.0001 //0.00001 //0.0000001

#define STEERING_KP 0.10
#define STEERING_KI 0

#define SPEED_KP 0.1
#define SPEED_KI 0

#define MOTOR_SAMPLES 300
#define NAVIGATION_SAMPLES 200


// Global variables
// ----------------------------------------------------------------
// IO Port
extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;
extern DigitalOut leftDir;
extern DigitalOut rightDir;
extern DigitalOut spiReset;
extern DigitalOut ioReset;

// Comunication 
extern SPI deSpi;
extern Pixy pixy;
extern Serial pc; // PC serial channel

// Control
extern PeriodicPI leftMotorPI;
extern PeriodicPI rightMotorPI;
extern PeriodicPI heightPI;
extern PeriodicPI xPI;

// Other
extern PwmOut leftPwm; 
extern PwmOut rightPwm; 

// Method prototypes
void FlushBuffer(void);
float RadsPerSec(short counts, short time);