#include "global.h"

// IO Port
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut leftDir(p23); //
DigitalOut rightDir(p22); //
DigitalOut spiReset(p14); //changed
DigitalOut ioReset(p15); //

// Comunication 
SPI deSpi(p5, p6, p7);
Pixy pixy(Pixy::SPI, p11, p12, p13);
Serial pc(USBTX, USBRX); // PC serial channel
//Serial pc(p9, p10); // Bluetooth serial channel

// Control
PeriodicPI leftMotorPI(MOTOR_PERIOD, MOTOR_KP, MOTOR_KI);
PeriodicPI rightMotorPI(MOTOR_PERIOD, MOTOR_KP, MOTOR_KI);
PeriodicPI heightPI(NAVIGATION_PERIOD, SPEED_KP, SPEED_KI);
PeriodicPI xPI(NAVIGATION_PERIOD, STEERING_KP, STEERING_KI);

// Other
PwmOut leftPwm(p24); 
PwmOut rightPwm(p21); 

// Converts measurements from the FPGA to rads/sec
float RadsPerSec(short counts, short time) {    
    return ((float)counts*26.558)/time;
}

// Returns the last character
void FlushBuffer(void) { 
    while (pc.readable()) pc.getc();
}