#ifndef TESTS_H
#define TESTS_H

#include "ball_test.h"
#include "map_test.h"

/** Tests
@brief Runs all tests for the Labyrinth game
@returns The total number of failures in the testbenches
*/ 

int no_of_tests_failed(){
    //initialise failures to 0
    int quantity_failed = 0;
    
    //run ball test
    printf("Testing ball movement:\n");
    bool balltest = ball_test();
        //print results to terminal and increment failure count if failed
    if(balltest){ printf("Ball test passed.\n"); }
    else if (!(balltest)){
        printf("Ball test failed!\n");
        quantity_failed++;
    }
    //run map test
    printf("Testing map pixel reading:\n");
    bool maptest = map_test();
            //print results to terminal and increment failure count if failed
    if(maptest) {printf("Map test passed.\n"); }
    else if (!(maptest)){
        printf("Map test failed!\n");
        quantity_failed++;
    }
    //Summary of results printed to terminal
    printf ("Total tests failed = %d\n", quantity_failed);
    
    return quantity_failed;
}
#endif