#include "Pause.h"

//constructor
Pause::Pause(){
}

//destructor
Pause::~Pause(){
}

////initialiser
void Pause::init(){
    _state = RESUME;        //set arrows to point to first item in the menu
}

PauseOption Pause::pause_menu(Gamepad &gamepad, N5110 &lcd, int fps){
    PauseOption choice = RESUME;        //choice stores the state to be selected and pointed to with arrows
    while(!(gamepad.check_event(gamepad.A_PRESSED))){   //check for user selection
        lcd.clear();
        display_pause_options(lcd);         //render the menu on the screen
        choice = pause_selection(gamepad, lcd);     //update currently selected choice and point to it with arrows
        lcd.refresh();
        wait(0.2);      //avoid button bounce as much as poss
    }
    return choice;
}



int Pause::brickbreaker_action(PauseOption choice, Gamepad &gamepad, N5110 &lcd, int frame, int fps){    
    int jump_to_frame = frame;
    if(choice == RESUME){ jump_to_frame = frame; }              //Just keep code iterating
    if(choice == RESTART){ jump_to_frame = 0; }                 //return to frame 1 if restarted
    if(choice == QUIT){ jump_to_frame = 45*fps; }               //jump to final frame
    if(choice == HELP){ brickbreaker_help(gamepad, lcd); }      //display relevant help screen
    return jump_to_frame;                       
}


void Pause::display_pause_options(N5110 &lcd){
    lcd.printString("GAME PAUSED:", 6, 0);      //text for each line of the display
    lcd.printString("Resume", 24, 1);
    lcd.printString("Restart", 21, 2);
    lcd.printString("Quit", 30, 3);
    lcd.printString("Help", 30, 4);
    lcd.printString("(Select = A)", 6, 5);
}

PauseOption Pause::pause_selection(Gamepad &gamepad, N5110 &lcd){
    PauseSelection fsm[4] = {       //state machine to power the pause menu
        {1,{HELP,RESTART,RESUME}},      //output (1,2,3 or 4) is the line to print the arrows on
        {2,{RESUME,QUIT,RESTART}},      //next_state[0] is the option above the current item
        {3,{RESTART,HELP,QUIT}},        //next_state[1] is the option below the current item
        {4,{QUIT,RESUME,HELP}}          //next_state[2] is the current item/state
    };
    if(gamepad.get_direction() == N){ _next_state = 0;}         //move up
    else if(gamepad.get_direction() == S){ _next_state = 1;}        //move down
    else{ _next_state = 2;}         //arrows in same position (default)
    _state = fsm[_state].next_state[_next_state];       //update state
    lcd.printString(">", 6, fsm[_state].output);        //print arrows to LCD display
    lcd.printString("<", 72, fsm[_state].output);
    return _state;
}

void Pause::classic_help(Gamepad &gamepad, N5110 &lcd){
    while(!(gamepad.check_event(gamepad.A_PRESSED))){       //check for user advancing
        lcd.clear();
        lcd.printString("Help", 30, 0);             //display each line of help 
        lcd.printString("Don't leave", 0, 1);       //on LCD display
        lcd.printString("the path! Tilt", 0, 2);
        lcd.printString("pad to roll", 0, 3);
        lcd.printString("the ball", 0, 4);
        lcd.printString("(Press A)", 0, 5);
        lcd.refresh();
        wait(0.5);
    }
}

void Pause::brickbreaker_help(Gamepad &gamepad, N5110 &lcd){
    while(!(gamepad.check_event(gamepad.A_PRESSED))){       //check for user advancing
        lcd.clear();
        lcd.printString("Help", 30, 0);                 //display each line of help
        lcd.printString("Tilt gamepad", 0, 1);          //on LCD display
        lcd.printString("to move ball", 0, 2);
        lcd.printString("Game length=", 0, 3);
        lcd.printString("45 secs", 0, 4);
        lcd.printString("(Press A)", 0, 5);
        lcd.refresh();
        wait(0.5);
    }
}