#ifndef MAP_TEST_H
#define MAP_TEST_H

/** Map test
@brief Check that the map generates 1s and 0s correctly without the accelerometer
@returns true if it generates values as expected, false if not
*/

bool map_test(){
    Map map;
    map.init();
    bool passed = true;
    Vector2D coord = {0,0};     //top left coord
    printf("Running...\n");
    
    int pixel = map.get_coordinate(coord);
    printf("1st pixel = %d\n", pixel);
    if (pixel != 1) {      //test 1 - test what should be a black pixel
        passed = false;
        printf("Coord 1 failed\n");
        }
    coord.x = 60;        //start area coord
    coord.y = 60;
    
    pixel = map.get_coordinate(coord);
    printf("2nd pixel = %d\n", pixel);
    if (pixel != 0) {         //test 2 - test what should be a white pixel
        passed = false;
        printf("Coord 2 failed\n");
        }
    return passed;
}

#endif