#include "Map.h"

Map::Map(){
}

Map::~Map(){
}

void Map::init(){
    _coord.x = 47;      //initialise the map region to the start area
    _coord.y = 25;
}

void Map::read_input(FXOS8700CQ &accelerometer, Ball &ball){
    Data values = accelerometer.get_values();
    int ball_speed = ball.get_ball_speed();     //get the sensitivity from ball object
    _map_change.x = -0.25*(1+0.5*ball_speed)*values.ay;      //axes of accelerometer different to gamepad so use -y for x and vice versa
    _map_change.y = -0.25*(1+0.5*ball_speed)*values.ax;
}

void Map::update(){
    _coord.x += _map_change.x;      //map change is the equivalent of velocity in ball.cpp
    _coord.y += _map_change.y;
    if(_coord.x < 0){ _coord.x = 0;}        //boundary conditions to stop the 
    if(_coord.y < 0){ _coord.y = 0;}        //the programme trying to display
    if(_coord.x > 506) {_coord.x = 506;}    //undefined region outside the
    if(_coord.y > 176) {_coord.y = 176;}    //gamemap array
}

void Map::draw(N5110 &lcd){
    bool pixelstate = false;
    for(int y = _coord.y; y < (48+_coord.y); y++){          //row by row
        for(int x = _coord.x; x < (84+_coord.x); x++){      //get each pixel from the
            if(gamemap[y][x] == 1){ pixelstate = true;}     //gamemap array
            else{ pixelstate = false;}                      //and set the pixel according to its value in gamemap array
            lcd.setPixel((x-_coord.x), (y-_coord.y), pixelstate);   //easier to use than draw sprite with only part of a very large sprite
        }
    }
}

Vector2D Map::get_map_display(){
    Vector2D top_left_coord = _coord;   //top left coord used to represent entire screen region
    return top_left_coord;
}

void Map::set_map_display(Vector2D coord){
    _coord = coord;     //change private member variable
}

bool Map::check_wall_collision(Gamepad &gamepad, Ball &ball){
    bool collision = false;
    Vector2D ball_screen_pos = ball.get_position();
    Vector2D c;
    c.x = ball_screen_pos.x + _coord.x;     //c represents the absolute position of the ball's centre
    c.y = ball_screen_pos.y + _coord.y;     //relative to the game map
    Vector2D ball_pixels[37] = {
        {c.x,c.y},{c.x+1,c.y},{c.x+2,c.y},{c.x+3,c.y},{c.x-1,c.y},{c.x-2,c.y},          //this is every pixel in ball
        {c.x-3,c.y},{c.x,c.y+1},{c.x+1,c.y+1},{c.x+2,c.y+1},{c.x+3,c.y+1},
        {c.x-1,c.y+1},{c.x-2,c.y+1},{c.x-3,c.y+1},{c.x,c.y-1},{c.x+1,c.y-1},            //could this be done with
        {c.x+2,c.y-1},{c.x+3,c.y-1},{c.x-1,c.y-1},{c.x-2,c.y-1},{c.x-3,c.y-1},          //same algorithm as for 
        {c.x,c.y+2},{c.x+1,c.y+2},{c.x+2,c.y+2},{c.x-1,c.y+2},{c.x-2,c.y+2},            //lcd.drawCircle?
        {c.x,c.y-2},{c.x+1,c.y-2},{c.x+2,c.y-2},{c.x-1,c.y-2},{c.x-2,c.y-2},
        {c.x,c.y+3},{c.x+1,c.y+3},{c.x-1,c.y+3},{c.x,c.y-3},{c.x+1,c.y-3},              //this is fixed for a radius of 3
        {c.x-1,c.y-3}   };
    for(int i = 0; i < 37; i++){
        int y = ball_pixels[i].y;
        int x = ball_pixels[i].x;
        if(gamemap[y][x] == 1){         //check each pixel in the ball to see if it is on a '1' in game map (representing wall)
            collision = true;
            break;          //break with true if wall collision
        } else { collision = false; }       //keep iterating if not
    }
    return collision;
}

int Map::get_coordinate(Vector2D coord){
    int position;
    int x = coord.x;
    int y = coord.y;
    if(gamemap[y][x] == 1){ position = 1; } //find the desired coord in the game map
    else{ position = 0; }      //return true if its a wall, false if it's pathway
    return position;
}