#include "BrickBreakerEngine.h"

//Constructor
BrickBreakerEngine::BrickBreakerEngine(){
}

//Destructor
BrickBreakerEngine::~BrickBreakerEngine(){
}

//Initialiser
void BrickBreakerEngine::init(int radius, Ball &ball){
    _ball_radius = radius;
    ball.init(_ball_radius);
    srand(time(NULL));                  //first square will be the same each time
    _square_coord.x = 2 + rand()%80;    //but is randomly generated by random noise thereafter
    _square_coord.y = 8 + rand()%36;
}

/////////////Brickbreaker functionality/////////////////////

void BrickBreakerEngine::brickbreaker_draw(N5110 &lcd, Ball &ball){
    ball.draw(lcd);     //draw ball
    lcd.drawRect(_square_coord.x, _square_coord.y, 5, 5, FILL_BLACK);   //draw randomly generated square
    print_score(lcd);       //draw score in corner
}

void BrickBreakerEngine::set_score(int score){
    _score = score;         //used to initialise score upon restart
}

void BrickBreakerEngine::generate_rand_square(AnalogIn &randnoise){
    int rand = randnoise.read_u16();            //noise on unconnected ADC channel expanded to 16 bit int
    Vector2D square_coords = {rand % 80, 8 + rand % 36};    //offset by 8 so it doesn't overlap the score
    _square_coord = square_coords;      //update the square coordinates for rendering
}

void BrickBreakerEngine::check_square_collision(AnalogIn &randnoise, Ball &ball){
    int radius = ball.get_radius();
    Vector2D position = ball.get_position();
    if (abs(position.x - (_square_coord.x + 2)) <= (radius + 2) and         //adding 2 to square coords gives the centre of the square
        abs(position.y - (_square_coord.y + 2)) <= (radius + 2)) {          // <= radius+2 checks that edges aren't touching rather than centres of each
            _score++;           //increment score if collision
            generate_rand_square(randnoise);        //generate new square
    }
}

void BrickBreakerEngine::print_score(N5110 &lcd){
    char buffer[2];
    int score = _score;
    sprintf(buffer, "%d", score);       //use sprintf so that a variable (rather than a constant) can be use in printString.
    lcd.printString(buffer, 72, 0);     //print in top right corner of the screen
}

void BrickBreakerEngine::read_high_scores(){
    FILE *fp;                                   //open file stream
    fp = fopen("/sd/bbhighscores.txt", "r");    //open file for brickbreak high scores
    
    if(fp == NULL){
        printf("Error: Could not open file");   //check successfully opened
    } else {
        int i = 0;
        rewind(fp);         //return to start of file
        
        while(fscanf(fp, "%d,%f", &_index_array[i], &_array_of_values[i]) != EOF){  //read into respective arrays while iterating through line by line
            i++;        //increment which line of array to write into
        }
        fclose(fp);     //close file stream
    }
}

void BrickBreakerEngine::check_high_score(){
    read_high_scores();
    for(int i = 4; i >= 0; i--){                            //quick algorithm to keep moving the current score
        if(_array_of_values[i] < _score){                   //up the leaderboard until it reaches a score greater than itself
            _array_of_values[i+1] = _array_of_values[i];
            _array_of_values[i] = _score;                   //note: requires the file to be initialised with dummy scores in descending order
        }
    }               //produces updated array with the current score integrated into high scores if its a top 5 score
}

void BrickBreakerEngine::write_high_scores(){
    check_high_score();
    FILE *fp;           //open file stream
    fp = fopen("/sd/bbhighscores.txt", "w");        //open brickbreaker high score file ready for writing
    if(fp == NULL){
        printf("Error: Could not open file");       //check open
    } else {
        for(int i = 0; i < 5; i++){                 
            fprintf(fp, "%d, %f\n", _index_array[i], _array_of_values[i]);      //send first 5 values of index and value array to SD card
        }
        fclose(fp);         //close file stream
    }
}

void BrickBreakerEngine::time_warning(Gamepad &gamepad, int frame, int fps){
    gamepad.leds_on();          //initially set all LEDs on
    int game_length = 45 * fps;
    if(frame > 0.17 * game_length){     //when 1/6th of game played, turn first LED off
        gamepad.led(6, 0);
    }
    if(frame > 0.33 * game_length){     //when 1/3rd of game played, turn second LED off
        gamepad.led(5, 0);
    }
    if(frame > 0.5 * game_length){      //1/2 played, turn 3rd LED off
        gamepad.led(4, 0);
    }
    if(frame > 0.67 * game_length){     //2/3 played, turn 4th off
        gamepad.led(3, 0);
    }
    if(frame > 0.83 * game_length){     //5/6th played, turn 5th off
        gamepad.led(2, 0);
    }
    if(frame > 0.97 * game_length){     //turn final one off just before the game ends
        gamepad.led(1, 0);
    }
}
    
void BrickBreakerEngine::end(Gamepad &gamepad, N5110 &lcd){
    while(!(gamepad.check_event(gamepad.A_PRESSED))){       //check when user wants to advance
        lcd.clear();
        char buffer[2];
        sprintf(buffer, "%d", _score);          //read the final score into buffer
        lcd.printString("Time up!", 18, 1);
        lcd.printString("You scored:", 9, 3);       //display time up message
        lcd.printString(buffer, 36, 4);             //display final score
        lcd.printString("(A = back)", 24, 5);       //check for advance message
        lcd.refresh();
        wait(0.2);          //longer duration between frames to reduce button bounce impact
    }
}