#ifndef BALL_TEST_H
#define BALL_TEST_H

/** Ball Test
@brief Check that the ball moves as it should without seeding by the accelerometer
@returns true if moves correctly, false if moves incorrectly
*/

bool ball_test(){
    Ball ball;      //create ball object
    ball.init(3);    //set radius to 3
    Vector2D ball_pos = {10, 20};       //give ball initial position of (10,20)
    ball.set_position(ball_pos);
    Vector2D ball_vel = {3, -5};        //give ball initial velocity of (3, -5)
    ball.set_velocity(ball_vel);
    ball.update();                      //update ball position
    ball_pos = ball.get_position();     
    
    bool passed = true;
    if(ball_pos.x != 13){ passed = false; }         //check whether ball in correct position
    else if(ball_pos.y != 15){ passed = false; }    //return false if not
    else { passed = true; }
    return passed;
}

#endif