#include "Ball.h"

Ball::Ball()
{}

Ball::~Ball()
{}

void Ball::init(int radius){
    _radius = radius;
    _x = 42;            //start ball in the centre of the screen
    _y = 24;
    _velocity.x = 0;    //initially have the velocity as 0 until the
    _velocity.y = 0;    //accelerometer senses otherwise
    _ball_speed = 5;    //medium sensitivity to tilt input
}

void Ball::draw(N5110 &lcd){
    int radius = get_radius();
    lcd.drawCircle(_x, _y, radius, FILL_BLACK);     //draw black circle at coord (x, y) with preset radius 
}

void Ball::read_input(FXOS8700CQ &accelerometer){
    Data values = accelerometer.get_values();
    _velocity.x = -(5+_ball_speed)*values.ay;        //axes of the accelerometer are different to orientation of the screen
    _velocity.y = -(5+_ball_speed)*values.ax;        //negative to account for reversed direction
}

void Ball::update(){
    int RADIUS = get_radius();
    _x += _velocity.x;          //update position based on how much tilt inputted
    _y += _velocity.y;
    if (_x < RADIUS){ _x = RADIUS;}             //check wall collisions
    if (_x > 84 - RADIUS){ _x = 83 - RADIUS;}   //if ball position is going to
    if (_y < RADIUS){ _y = RADIUS;}             //exceed boundaries of the screen
    if (_y > 48 - RADIUS){ _y = 47 - RADIUS;}   //then fix it to the edge of the screen
    printf("ball speed = %d\n", _ball_speed);
}

Vector2D Ball::get_position(){
    Vector2D pos = {_x, _y};    //combine x and y into Vector2D
    return pos;
}

Vector2D Ball::get_velocity(){
    Vector2D vel = {_velocity.x, _velocity.y};      //combine velocity.x and .y into a Vector2D
    return vel;
}

int Ball::get_radius(){
    int radius = _radius;       //find from private member variable
    return radius;
}

int Ball::get_ball_speed(){
    int ball_speed = _ball_speed;       //find from private member variable
    return ball_speed;
}

void Ball::set_ball_speed(int ball_speed){
    _ball_speed = ball_speed;           //update private member variable with user input
}

void Ball::set_velocity(Vector2D vel){
    _velocity.x = vel.x;                //must pass each part of the struct individually,
    _velocity.y = vel.y;                //can't pass both at once
}

void Ball::set_position(Vector2D pos){
    _x = pos.x;         //as with set_velocity
    _y = pos.y;
}

void Ball::set_radius(int radius){
    _radius = radius;       //don't use in code, other than initially where radius is defined using #define in main.cpp
}