#include "mbed.h"

DigitalIn enc_pb (p5);
InterruptIn enc_A (p6);
InterruptIn enc_B (p7);
PwmOut led1 (p22);
PwmOut led2 (p23);

void enc_int_routine (void);

bool enc_A_state;
bool enc_B_state;
bool old_enc_A_state;
bool old_enc_B_state;
int val_min = 0;
int val_max = 100;
int val = ((val_max - val_min) / 2) + val_min;
int val_old = val;

int main() {
    enc_pb.mode(PullUp);
    enc_A.mode(PullUp);
    enc_B.mode(PullUp);
    enc_A_state = enc_A;
    enc_B_state = enc_B;
    enc_A.rise(&enc_int_routine);
    enc_B.rise(&enc_int_routine);
    enc_A.fall(&enc_int_routine);
    enc_B.fall(&enc_int_routine);
    while (1) {
        if (val != val_old) {
            printf("\n\r%i",val);
        } // if (val != val_old)
        val_old = val;
        if (enc_pb) {
            led1 = val / 100.0;
            led2 = 1.0 - (val / 100.0);
        } else {
            printf("button\n\r");
            led1 = 0;
            led2 = 0;
        } // if (enc_pb)
    } // while(1)
} // end main

void enc_int_routine (void) {
    old_enc_A_state = enc_A_state;
    old_enc_B_state = enc_B_state;
    enc_A_state = enc_A;
    enc_B_state = enc_B;
    if (((enc_A_state != old_enc_A_state) && (enc_B_state != old_enc_B_state)) || ((enc_A_state == old_enc_A_state) && (enc_B_state == old_enc_B_state))) {
        val = val;
    } else {
        if (enc_A_state ^ old_enc_B_state) {
            val -= 1;
        } else {
            val += 1;
        } // (enc_A_state ^ old_enc_B_state)
    } // if ((enc_A_state != old_enc_A_state) && (enc_B_state != old_enc_B_state))
} // end enc_A_int_routine