#include "mbed.h"

DigitalIn sw_in (p5);
InterruptIn enc_a (p6);
InterruptIn enc_b (p7);
PwmOut led1 (p22);
PwmOut led2 (p23);

void enc_a_int_routine (void);
void enc_b_int_routine (void);

bool enc_a_state;
bool enc_b_state;
bool old_enc_a_state;
bool old_enc_b_state;
int val_min = 0;
int val_max = 100;
int val = ((val_max - val_min) / 2) + val_min;
int val_old = val;

int main() {
    sw_in.mode(PullUp);
    enc_a.mode(PullUp);
    enc_b.mode(PullUp);
    enc_a_state = enc_a;
    enc_b_state = enc_b;
    enc_a.rise(&enc_a_int_routine);
    enc_b.rise(&enc_b_int_routine);
    enc_a.fall(&enc_a_int_routine);
    enc_b.fall(&enc_b_int_routine);
    while (1) {
        if (val != val_old) {
            printf("\n\r%i",val);
        } // if (val != val_old)
        val_old = val;
        if (sw_in) {
            led1 = val / 100.0;
            led2 = 1.0 - (val / 100.0);
        } else {
            printf("button\n\r");
            led1 = 0;
            led2 = 0;
        } // if (sw_in)
    } // while(1)
} // end main

void enc_a_int_routine (void) {
    old_enc_a_state = enc_a_state;
    old_enc_b_state = enc_b_state;
    enc_a_state = enc_a;
    enc_b_state = enc_b;
    if (((enc_a_state != old_enc_a_state) && (enc_b_state != old_enc_b_state)) || ((enc_a_state == old_enc_a_state) && (enc_b_state == old_enc_b_state))) {
        val = val;
    } else {
        if (enc_a_state ^ old_enc_b_state) {
            val -= 1;
        } else {
            val += 1;
        } // (enc_a_state ^ old_enc_b_state)
    } // if ((enc_a_state != old_enc_a_state) && (enc_b_state != old_enc_b_state))
} // end enc_a_int_routine

void enc_b_int_routine (void) {
    old_enc_a_state = enc_a_state;
    old_enc_b_state = enc_b_state;
    enc_a_state = enc_a;
    enc_b_state = enc_b;
    if (((enc_a_state != old_enc_a_state) && (enc_b_state != old_enc_b_state)) || ((enc_a_state == old_enc_a_state) && (enc_b_state == old_enc_b_state))) {
        val = val;
    } else {
        if (enc_a_state ^ old_enc_b_state) {
            val -= 1;
        } else {
            val += 1;
        } // (enc_a_state ^ old_enc_b_state)
    } // if ((enc_a_state != old_enc_a_state) && (enc_b_state != old_enc_b_state))
} // end enc_a_int_routine