#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h"
#include "math.h"
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif
#define M_PI 3.14159265358979323846

#define MMA8451_I2C_ADDRESS (0x1d<<1)

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

//unidades:
DigitalOut uni1(PTC9);       //(g)
DigitalOut uni2(PTC8);      //(f)
DigitalOut uni3(PTD4);     //(e)
DigitalOut uni4(PTA12);   //(d)
DigitalOut uni5(PTA4);   //(c)
DigitalOut uni6(PTA5);  //(b)
DigitalOut uni7(PTC6); //(a)

DigitalOut dec1(PTC12);
DigitalOut dec2(PTC13);
DigitalOut dec3(PTC16);
DigitalOut dec4(PTC17);
DigitalOut dec5(PTA13);
DigitalOut dec6(PTD5);
DigitalOut dec7(PTD0);

BusOut display(PTC9,PTC8,PTD4,PTA12,PTA4,PTA5,PTC6);

DigitalOut habuni(PTD7);
DigitalOut habdec(PTD6);

DigitalIn enta(PTC7);
DigitalIn entb(PTC0);
DigitalIn entc(PTC3);
DigitalIn entd(PTC4);

AnalogIn analog1(PTB1);

DigitalIn digital1(PTB2);
DigitalIn digital2(PTB3);
int a=0;
unsigned int e=0,cuenta=2,cantidad=4,estado=0,mal=0,nuevo=0,erro=0,b=0,demo=0,ap=4,tiempo=20,s=0,acta=0,actb=0,actc=0,actd=0,uni=0,dec=0,bar=0,guar1=0,guar2=0,l1,l2,l3,d=0,la1=0,la2=0,la3=0,partea,parteb;
int anl1,anl2,esto;
int dig1,dig2;
int dato[50]= {0,1,2,3},almacen[15];
int dato2[50];
Ticker barrido;
Ticker jorge;
void funcion();
void ctrl_barrido();



//Definimos que el puerto serie se llama pc
Serial pc(USBTX, USBRX);
//Variable donde se guarda lo leido
char buffer[128];
 char c;
//bit usado como flag para procesar datos
bool newdata = false;   //Se pone en true cuando hay nuevos datos

//Creamos los tres leds pra usar
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

AnalogOut dac(PTE30);

//Callback cuando se detecta una entrada
void onCharReceived()
{
    //Copiamos lo leido en c


    c = pc.getc();
    newdata = true;



}



//function : hex2int
//this function will return integer value against
//hexValue - which is in string format
 


int main()
{
//Apagamos los leds
    led1 = 1;
    led2 = 1;
    led3 = 1;
//Ejecutar onCharReceived por cada entrada por puerto
    pc.attach(&onCharReceived);
    TSIAnalogSlider tsi(ELEC0, ELEC1, 100);

    while (true) {

        if(newdata==true) {
            newdata=false;


            switch(estado) {
                default:
                case 0:
                    esto=0;
                    //printf("caso 1\n");

                    d=0;
                    if(c=='$')
                        estado=1;
                    a='$';
                    la1=led1;
                    la2=led2;

                    la3=led3;


                    break;
                case 1:
                    if (c=='R') {
                        estado=2;
                        a=a^'R';
                    }
                    if (c=='W') {
                        estado=11;
                        a=a^'W';
                    }
                    
                    if(estado==1)
                        estado=0;
                        
                        if (c=='$') {
                        estado=1;
                        a='$';
                    }

                    break;
                case 2:
                    if(c=='A') {

                        a=a^'A';
                        estado=4;
                    }
                    if(c=='L') {
                        a=a^'L';
                        estado=6;
                    }
                    if(c=='D') {
                        a=a^'L';
                        estado=26;
                    }
                    
                    if(c=='I') {
                        a=a^'I';
                        estado=5;
                    }
                    if(estado==2)
                        estado=0;


                    break;
                    
                case 26:
                    if(c=='1') {
                        a=a^'1';
                        e=26;
                        //$RD1ff!
                        estado=27;
                    }
                    break;
                    
                case 27:
                        
                        
                        //$RD1f
                        
                        
                        esto=c*10;
                        estado=28;
                        // printf("tenemos ahora %d\n",esto);
                        
                       
                        break;
                        
                case 28:
                
                        esto=esto+c;
                        float susso =(((esto/99.0)-5.5)/1.3);
                        printf("eee   %f   eee",susso);
                        
                        
                        dac=susso;
                        estado=0;
                        break;
                        /*if(c=='0')
                        c=0;
                        if(c=='1')
                        c=1;
                        if(c=='2')
                        c=2;
                        if(c=='3')
                        c=3;
                        if(c=='4')
                        c=4;
                        if(c=='5')
                        c=5;
                        if(c=='6')
                        c=6;
                        if(c=='7')
                        c=7;
                        if(c=='8')
                        c=8;
                        if(c=='9')
                        c=9;
                        if(c=='A')
                        c=10;
                        if(c=='B')
                        c=11;
                        if(c=='C')
                        c=12;
                        if(c=='D')
                        c=13;
                        if(c=='E')
                        c=14;
                        if(c=='F')
                        c=15;
                        esto=esto+c;
                        //$RD1ff!
                        estado=0;
                        //printf("tenemos %d\n",esto);
                        float susso = (1.0/165.0)*esto; 
                        dac=susso;
                        break;*/
                    
                    
                case 3:

                    if(c=='R') {
                        a=a^'R';
                        e=81;
                    }
                    if(c=='G') {
                        a=a^'G';

                        e=91;
                    }
                    if(c=='B') {
                        a=a^'B';
                        e=111;
                    }

                    estado=12;
                    if(c!='R'&&c!='G'&&c!='B')
                        estado=9;

                    break;

                case 4:
                    if(c=='1') {
                        a=a^'1';
                        e=1;

                    }
                    if(c=='2') {
                        a=a^'2';
                        e=2;

                    }

                    estado=7;
                    if(c!='2'&&c!='1')
                        estado=9;

                    break;

                case 5:
                    if(c=='1') {
                        a=a^'1';
                        e=3;
                    }
                    if(c=='2') {
                        a=a^'2';
                        e=4;
                    }

                    estado=7;
                    if(c!='2'&&c!='1')
                        estado=9;
                    break;

                case 6:
                    l1=led1;
                    l2=led2;
                    l3=led3;
                    if(c=='R') {
                        a=a^'R';
                        e=5;
                    }
                    if(c=='G') {
                        a=a^'G';
                        e=6;
                    }
                    if(c=='B') {
                        a=a^'B';
                        e=7;

                    }
                    estado=7;
                    if(c!='R'&&c!='G'&&c!='B')
                        estado=9;
                    break;

                case 7:

                    if(c<97)
                        b=c-48;
                    else
                        b=c-87;
                    estado=8;
                    break;

                case 8:

                    if(c<97)
                        d=c-48;
                    else
                        d=c-87;
                    b=(b*16)+d;
                    estado=10;
                    if(b!=a) {
                        estado=9;

                    }

                    break;

                case 9:
                    printf("algo estaba mal\n");

                    estado=0;
                    break;

                case 11:
                    if(c=='L') {
                        a=a^'L';
                        estado=3;
                    } else
                        estado=0;
                    break;
                case 12:
                    if(e==81) {
                        if(c=='1') {
                            e=8;
                        }
                        if(c=='0') {
                            e=9;
                        }
                    }
                    if(e==91) {
                        if(c=='1') {
                            e=10;
                        }

                        if(c=='0') {
                            e=11;
                        }
                    }
                    if(e==111) {
                        if(c=='1') {
                            e=12;
                        }

                        if(c=='0') {
                            e=13;
                        }
                    }
                    a=a^c;
                    estado=7;
                    if(c!='0'&&c!='1')
                        estado=9;

                    break;

                case 10:
                    if(c=='!') {
                        switch(e) {

                    case 1:
                        anl1=tsi.readPercentage()*255;

                        printf("$RA1%x060%x!\n",anl1,b);
                        break;
                    case 2:
                        anl2=analog1*255;

                        printf("$RA2%x050%x!\n",anl2,b);
                        break;
                    case 3:
                        dig1=digital1;
                        dig2=digital2;
                        printf("$RI1%d0e0%x!\n",dig1,b);
                        break;
                    case 4:
                        dig1=digital1;
                        dig2=digital2;
                        printf("$RI2%d0d0%x!\n",dig2,b);
                        break;
                    case 5:
                        printf("$RLR%d68%x!\n",l1,b);
                        break;
                    case 6:
                        printf("$RLG%d7d%x!\n",l2,b);
                        break;
                    case 7:
                        printf("$RLB%d78%x!\n",l3,b);
                        break;

                    case 8:
                        led1=1;
                        printf("$WLR15c%x!\n",b);
                        break;
                    case 9:
                        led1=0;
                        printf("$WLR05d%x!\n",b);
                        break;
                    case 10:
                        led2=1;
                        printf("$WLG149%x!\n",b);
                        break;
                    case 11:
                        led2=0;
                        printf("$WLG048%x!\n",b);
                        break;
                    case 12:
                        led3=1;
                        printf("$WLB14c%x!\n",b);
                        break;
                    case 13:
                        led3=0;
                        printf("$WLB04f%x!\n",b);
                        break;
                    
                        

                    }
            }
            estado=0;

        }



    }

}
}

