#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h"
#include "math.h"

#include "Dht11.h"






#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif
#define M_PI 3.14159265358979323846

#define MMA8451_I2C_ADDRESS (0x1d<<1)

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif


//InterruptIn ent(PTD5);

DigitalIn enta(PTD5);
Dht11 sensor(PTD7);
AnalogIn   ain(A0);
AnalogIn cooler(PTB3);

unsigned int e=0,cuenta=2,hay=0,estado=0,paso=0,rpma=0,rpmb=0,caso=0,tiempo=9,d=0,c=0,acta=0,tempp=0,entad=0,cuentar=0,rpm=0,f=0,rpmr=1800,rpmd=200,maestro=0,rpmo=0,mostramos=0;
double arr=0.055,ard=0.000258;
double t;
double j;
double m;

Ticker jorge;
Ticker ernesto;
void funcion();
void tiemporpm();
PwmOut fan(A1);

int mostrar = 0;



int main(void)
{


    jorge.attach(&funcion, 0.01);
    ernesto.attach(&tiemporpm, 2);
    TSIAnalogSlider tsi(ELEC0, ELEC1, 100);



    while (true) {

        if(mostrar) {
            printf("RPM = %d \r\n",rpm);
            printf("temperatura: %d \r\n",f);
            mostrar = 0;
        }


        m=cooler;


        switch (caso) {
            default:
            case 0:
                if(entad==1) {
                    fan=(0.0055*((f - 20)/50.0)) + 0.000258;
                    if(rpm==0)
                        caso=1;
                    
                    




                } else {

                    fan=0.0008;
                    if(rpm==0)
                        caso=1;

                    
                    
                }
                break;



            case 1:
                fan=0.002;
                
                if(e==1) {
                    
                    caso=0;
                    e=0;

                }
                break;
        }
        switch (estado) {

            case 0:
                if(m>0.9) {
                    cuentar++;
                    estado=1;

                }
                break;
            case 1:
                if(m<0.1)
                    estado=0;
                break;


        }
        switch (tempp) {
            case 0:
                if(enta==0) {

                    tempp=1;
                    cuenta=0;
                }
                break;
            case 1:
                if(cuenta>=2) {
                    tempp=2;
                    if(entad==0)
                        entad=1;
                    else
                        entad=0;


                }
                break;
            case 2:
                if(enta==1) {
                    tempp=3;
                    cuenta=0;
                }
                break;
            case 3:
                if(cuenta>=2) {
                    tempp=0;


                }
                break;
        }


    }




}




void funcion()
{
    cuenta++;
}
void tiemporpm()
{
    t=fan;
    e=1;
    sensor.read();
    f=sensor.getCelsius();
    rpm=cuentar*30;
    cuentar=0;
    mostrar= 1;
}

