#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h"
#include "math.h"
#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif
#define M_PI 3.14159265358979323846

#define MMA8451_I2C_ADDRESS (0x1d<<1)

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif
DigitalOut ledazul(LED_BLUE);
DigitalOut ledverde(LED_GREEN);
DigitalOut ledrojo(LED_RED);
//unidades:


BusOut display(PTC9,PTC8,PTD4,PTA12,PTA4,PTA5,PTC6);

DigitalOut habuni(PTD7);
DigitalOut habdec(PTD6);

DigitalIn enta(PTC7);
DigitalIn entb(PTC0);
DigitalIn entc(PTC3);
DigitalIn entd(PTC4);

double a=0;
unsigned int e=0,cuenta=2,cantidad=4,estado=0,mal=0,nuevo=0,erro=0,b=0,demo=0,ap=4,tiempo=20,s=0,d=0,c=0,acta=0,actb=0,actc=0,actd=0,uni=0,dec=0,bar=0,guar1=0,guar2=0;

int dato[50]= {0,1,2,3};
int dato2[50];
Ticker barrido;
Ticker jorge;
void funcion();
void ctrl_barrido();

int main(void)
{
    dato2[0]=126; //Guardamos en este vector la informacion para formar los diferentes numeros en el display
    dato2[1]=48;
    dato2[2]=109;
    dato2[3]=121;
    dato2[4]=51;
    dato2[5]=91;
    dato2[6]=95;
    dato2[7]=112;
    dato2[8]=127;
    dato2[9]=123;
    barrido.attach(&ctrl_barrido,0.01); //Activamos el barrido cada 10ms
    jorge.attach(&funcion, 1); //Cada 1seg se activará el ticker
    TSIAnalogSlider tsi(ELEC0, ELEC1, 100); //El slider es para iniciar el juego
    ledrojo=1; //Apagamos todo por las dudas
    ledazul=1;
    ledverde=1;


    while (true) {
        a=tsi.readPercentage();
        ledverde=1;
        ledrojo=1;
        switch (estado) {
            default:
            case 0:
               
                
                if (bar==0) { //Si bar es 1 se muentra las decenas y si es 0 se muestra las unidades
                    habuni=1; //Se definen las habilitaciones para solo mostrar las unidades
                    habdec=0;

                    display=dato2[dec]; //Se envia la informacion a los displyas

                }

                if(bar==1) {
                    habuni=0; //Se definen las habilitaciones para solo mostrar las decenas
                    habdec=1;

                    display=dato2[dec]; //Se envia la informacion a los displyas


                }

                if(c==0) { //Aca se va a generar la secuencia aleatoria
                    dato[0]=rand() % (1+3);
                    dato[1]=rand() % (1+3);
                    dato[2]=rand() % (1+3);
                    dato[3]=rand() % (1+3);
                    c=1; //De esta manera solo se genera 1 y no se sobrescribe todo infinitamente
                }

                if(dato[1]==dato[0])
                    dato[1]=rand() % (1+3);

                if(dato[2]==dato[1]||dato[2]==dato[0])
                    dato[2]=rand() % (1+3);


                if(dato[3]==dato[2]||dato[3]==dato[1]||dato[3]==dato[0])
                    dato[3]=rand() % (1+3);



                if(d==0&&(dato[0]+dato[1]+dato[2]+dato[3])==6) { //Muestra esto solo 1 vez y cuando ya se generó la secuencia
                    printf("Apreta el pad para empezar\n");
                    d=1;
                }

                if(a>=0.4&&a<=0.6&&(dato[0]+dato[1]+dato[2]+dato[3])==6) { //Una vez que se aprieta el slider y la secuencia esta generada, podemos empezar el juego
                    if(enta==0&&entb==0&&entc==0&&entd==0) { //Verificamos si todos los cables estan conectados
                        estado=1;
                        tiempo=20; //Esta variable almacena el tiempo
                        ap=4; //AP es 4 cuando no se ha desconectado ningun cable
                        b=0; //Esta variable se usa para llevar la cuenta de las desconexiones
                        printf("El orden es: %d%d%d%d\n",dato[0],dato[1],dato[2],dato[3]); //Imprime en PC el orden de la secuencia
                        acta=0; //Cada vez que se detecta una desconexion, se pone en 1 estas variables para poder ignorarlas luego de su primera deteccion
                        actb=0; //Por eso siempre hay que volverlas a 0 antes de empezar
                        actc=0;
                        actd=0;
                    } else {
                        if(d==1) { //Solo si la secuencia ya se genero
                            printf("Te falta conectar los cables \n"); //Aviso si no todos los cables estan conectados a gnd
                        }
                    }


                    break;
                case 1:
                    if(e==1) {

                        e=0; //Volvemos 0 la variable del ticker luego de detectarla

                    }

                    if (bar==0) {
                        habuni=1; 
                        habdec=0;

                        display=dato2[dec];

                    }

                    if(bar==1) {
                        habuni=0;
                        habdec=1;

                        display=dato2[dec];


                    }

                    if(enta==1&&acta==0) { //Si se desconecta el cable 1 ponemos AP en su valor correspondiente y colocamos a acta en 1 para ignorar a enta

                        ap=0;
                        acta=1;

                    }
                    if(entb==1&&actb==0) {

                        ap=1; //Se guarda en AP el cable que fue desconectado
                        actb=1;

                    }
                    if(entc==1&&actc==0) {

                        ap=2;
                        actc=1;

                    }
                    if(entd==1&&actd==0) {

                        ap=3;
                        actd=1;


                    }

                    if(ap!=4) { //Si se desconecta algun cable entramos aca
                        if(ap==dato[b]) { //Si es correcto, avanzamos
                            b++; //Sumamos 1 a la variable que lleva la cuenta de las desconexiones



                            ap=4; //Ponemos AP en 4 otra vez porque ya vimos al cable que se desconecto
                            if(b==4) { //Si b es 4 significa que se desconectaron los 4 cables en el orden correcto, asi que vamos al estado 4
                                estado=4;
                                tiempo=9; //Fijamos el tiempo que va a estar el led verde titilando
                                ledverde=0; //Prendemos el led verde como felicitacion
                                e=0; //Colocamos en 0 la variable del ticker por las dudas
                                b=0; //Volvemos a 0 la cuenta de posiciones


                            }
                            c=0; //Ponemos c en 0 para que se pueda generar otra secuencia aleatoria
                            d=0; //Ponemos d en 0 para que se pueda mostrar un printf del case 0



                        } else {
                            //Si el dato es incorrecto explota la bomba
                            estado=3;
                            tiempo=9;

                            e=0;
                            b=0;
                            ledverde=1;
                            ledrojo=0; //Prendemos el led rojo de alarma
                        }
                    }


                    if(tiempo==0) { //Si el tiempo se termina tambien se pierde
                        guar1=0;
                        guar2=0;
                        dec=0;
                        estado=3;
                        tiempo=9;
                        ledrojo=0;
                        ledverde=1;
                        e=0;
                        b=0;

                    }

                    break;




                case 3:
                    ledverde=1;

                    if(tiempo%2==0) { //El led rojo y los displays titilan
                        habuni=0;
                        habdec=0;

                        ledrojo=1;

                        s=0;
                    } else {
                        if (bar==0) {
                            habuni=1;
                            habdec=0;

                            display=dato2[dec];

                        }

                        if(bar==1) {
                            habuni=0;
                            habdec=1;

                            display=dato2[dec];


                        }
                        ledrojo=0;

                        s=1;
                    }


                    if(tiempo==0) { //Cuando ya titilaron el tiempo completo, volvemos a empezar en el estado 0
                        estado=0;
                        d=0;
                        c=0;
                    }
                    break;


                case 4:
                    ledrojo=1;
                    if(tiempo%2==0) { //El led verde y los displays titilan porque evitamos que la bomba explote
                        habuni=0;
                        habdec=0;
                        ledverde=1;

                        s=0;
                    } else {
                        if (bar==0) {
                            habuni=1;
                            habdec=0;

                            display=dato2[dec];

                        }

                        if(bar==1) {
                            habuni=0;
                            habdec=1;
                            display=dato2[dec];

                        }

                        ledverde=0;

                        s=1;

                    }
                    e=0;
                    if(tiempo==0) { //Volvemos a empezar luego de terminar este juego
                        estado=0;
                        c=0;
                        d=0;
                    }
                    break;
                }
        }
    }
}

void ctrl_barrido()
{

    if(bar==0) { //Si bar es 1 se muentra las decenas y si es 0 se muestra las unidades
        bar=1;


        if(estado!=3&&estado!=4) { //Solo se cumple si no estamos en el estado de perder o ganar
            dec=tiempo/10; //Obtenemos el valor de las decenas
            guar1=dec;
        } else
            dec=guar1; //Si estamos en perder o ganar, solo nos importa el ultimo valor antes de que el juego termine
            
        if(estado==0) //Si estamos en el estado de inicio los displays tienen que mostrar solo el numero inicial
            dec=2;


    }

    else {
        bar=0;


        if(estado!=3&&estado!=4) { 
            dec=tiempo-(dec*10); //Obtenemos el valor de las unidades
            guar2=dec;
        } else
            dec=guar2; //Si estamos en perder o ganar, solo nos importa el ultimo valor antes de que el juego termine
            
            if(estado==0)//Si estamos en el estado de inicio los displays tienen que mostrar solo el numero inicial
            dec=0;
    }

}

void funcion()
{

    tiempo--; //Cada 1seg se decrece la variable tiempo
    e=1; //Cada 1seg se pone e en 1

}