#include "mbed.h"
#include "tsi_sensor.h"
#include "MMA8451Q.h"
#include "math.h"
#include "Dht11.h"




DigitalIn enta(PTD5,PullUp);
Dht11 sensor(PTD7);
AnalogIn   ain(A0);
AnalogIn cooler(PTB3);

unsigned int e=0,cuenta=2,hay=0,estado=0,paso=0,caso=0,tiempo=9,d=0,c=0,acta=0,tempp=0,entad=0,cuentar=0,rpm=0,f=0,maestro=0,mostramos=0,mostrar=0;

double t;
double m;

Ticker rapido;
Ticker lento;
void funcion();
void tiemporpm();
PwmOut fan(A1);




int main(void)
{

    rapido.attach(&funcion, 0.01); //Ticker para el antirebote
    lento.attach(&tiemporpm, 2); //Ticker para el calculo de las rpm y otras cosas




    while (true) {

        if(mostrar) { //Cada 2 segundos se activa esto
            printf("RPM = %d \r\n",rpm); //Mostramos las rpm
            printf("temperatura: %d \r\n",f); //Mostramos la temperatura actual
            mostrar = 0; //Volvemos 0 la variable para no entrar hasta los siguientes 2 segundos
            t=ain; //Guardamos el valor del potenciometro
            printf("%f",t); //Mostramos el potenciometro
        }





        switch (caso) { //Maquina de estados de control general
            default:
            case 0:
                if(entad==1) { //Si el modo seleccionado es el lazo cerrado, entramos aca
                    fan=(0.00155*((f - 20)/50.0)) + 0.00053; //Definimos el pwm segun la temperatura
                    if(rpm==0) //Si el cooler esta frenado, vamos al estado 1
                        caso=1;






                } else {

                    fan=(0.00155*t)+0.00053; //Si estamos en el modo de lazo abierto, definimos el pwm segun el potenciometro
                    if(rpm==0) //Si el cooler se frena, vamos al estado 1
                        caso=1;



                }
                break;



            case 1:
                fan=0.002; //Definimos una velocidad alta para asegurarnos de que el cooler gire

                if(e==1) {

                    caso=0; //Luego de 2 segundos volvemos al estado 0
                    e=0;

                }
                break;
        }

        m=cooler;
        switch (estado) { //Maquina para detectar los pulsos del sensor hall

            case 0:
                if(m>0.9) { //Si se vuelve 1, aumentamos la variable cuentar y vamos al estado 1
                    cuentar++;
                    estado=1;

                }
                break;
            case 1:
                if(m<0.1) //En el momento que se vuelve 0 volvemos al estado 0
                    estado=0;
                break;


        }
        switch (tempp) { //Maquina de estados para el antirebote y la seleccion de modo
            case 0:
                if(enta==0) { //Cuando se detecta que se presiona el pulsador avanzamos al siguiente estado y empezamos a contar desde 0

                    tempp=1;
                    cuenta=0;
                }
                break;
            case 1:
                if(cuenta>=2) { //Unva vez que pasaron los 20ms de seguridad podemos considerar que el pulsador se presiono
                    tempp=2;
                    if(entad==0) //Ahora que verificamos que el boton se presiona solo 1 vez, cambiamos el modo actual
                        entad=1;
                    else
                        entad=0;


                }
                break;
            case 2:
                if(enta==1) { //Ahora repetimos el proceso al soltar el pulsador
                    tempp=3;
                    cuenta=0;
                }
                break;
            case 3:
                if(cuenta>=2) {
                    tempp=0;


                }
                break;
        }


    }




}




void funcion()
{

    cuenta++; //Cada 10ms se aumenta esta variable para el antirebote


}
void tiemporpm()
{

    e=1;
    sensor.read();
    f=sensor.getCelsius(); //Leemos el sensor
    rpm=cuentar*30; //Multiplicamos la cantidad de vueltas que medimos en 2segundos por 20, asi obtenemos la cantidad para 1 minuto
    cuentar=0; //Luego volvemos esta variable a 0 para poder contar las revoluciones otra vez
    mostrar=1;
}

