/* Robot 1
Project 3: Autonomous Multi-Robot Security Alert System
Notes:
1. Code checks entry id from the PostToSever results
2. Sends two xvalue and yvalue to server
3. Wall-following routine
*/
#include "mbed.h"
#include "ESP8266.h"
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#include "HCSR04.h"  //Ultrasonic distance sensor lib

//Subfunctions
    void Forward(void);void Stop(void);void Right90(void);void Left90(void);
    int GetFrontDistance(void);int GetRightDistance(void);
    void ConnectToServer(void);unsigned int PostToServer(void);unsigned int GetCurrentEntryID(void);
    void CloseConnection(void); void Wifi(void); void ConnectToServer(void);
    void ThreatDetected(void); void EncoderCount(void);

//Pin Setup
    DigitalOut right_cont1(A2), right_cont2(A3), left_cont1(A0), left_cont2(A1), red(LED_RED), green(LED_GREEN); 
    DigitalIn sw2(SW2);
//Interrupt Setup
    InterruptIn EncoderIn(D7); //External Interrupt 
    InterruptIn ThreatIn(D9); //Clap sensor
//PWM Setup 
    PwmOut right_pwm(A5);
    PwmOut left_pwm(A4);
    
Serial pc(USBTX,USBRX); //Uart connection for TeraTerm
ESP8266 wifi(PTC17, PTC16, 115200); // tx, rx, baud rate for wifi

//Public variables
    int frontDistance = 0, rightDistance = 0, setDistance = 0, lastRightDistance = 0; 
    int xvalue = 0, yvalue = 0; 
    float leftSpeed = 0, rightSpeed = 0, ileftSpeed = 0, irightSpeed = 0, inc = 0; 

int main() 
{
    red = 1; green = 1; //off
    while(sw2);
    wait(2);
    pc.baud(9600);  
    pc.printf("starting\r\n");
    
    //Wifi();//send xvalue = 0, yvalue = 0 to ThinkSpeak.com
    
//enable inturrpts 
    EncoderIn.rise(&EncoderCount);  /*Interrupt: On rising edge of encoder tick*/
    ThreatIn.rise(&ThreatDetected);  /*Interrupt: On rising edge of encoder tick*/ 
//set motor period
  right_pwm.period(0.007f); 
  left_pwm.period(0.007f); 
  
//motor speed
    leftSpeed = 0.50f;
    rightSpeed = 0.70f; 
    ileftSpeed = 0.50f;
    irightSpeed = 0.70f;    
    left_pwm.write(ileftSpeed);  
    right_pwm.write(irightSpeed);
    Forward();   
    setDistance = GetRightDistance(); //check right distance distance
    lastRightDistance = setDistance; 
    pc.printf("setDistance:%d\r\n", setDistance);
    while(1) 
    { 
        EncoderIn.rise(NULL);  //disable EncoderIn inturrpt
         
        rightDistance = GetRightDistance(); //check distance
        if( rightDistance > (lastRightDistance + 20) || rightDistance < (lastRightDistance - 20))
        {
            pc.printf("Old righDistance:%d, lastRightDistance: %d\r\n", rightDistance, lastRightDistance);
            rightDistance = lastRightDistance -10; 
            pc.printf("New righDistance:%d\r\n", rightDistance);
        }
        else
            lastRightDistance = rightDistance; 
            
        frontDistance = GetFrontDistance(); //check distance 
        //pc.printf("Right:%d , Front: %d\r\n", rightDistance, frontDistance);
        
        if(rightDistance >=1000) 
        {
            rightDistance = 1;
        }
        else
            rightDistance = rightDistance; 
        //***turn right
        if( rightDistance > setDistance + 1 ) 
        {
            inc = 0.3f; 
            leftSpeed = leftSpeed + inc;
            if(leftSpeed > .55f)
                leftSpeed = .55f;
            left_pwm.write(leftSpeed);
            
            rightSpeed = rightSpeed - inc;
            if(rightSpeed < 0.30f)
                rightSpeed = 0.30f; 
            right_pwm.write(rightSpeed);
            pc.printf("Turn Right,right distance:%d, %d\r\n", rightDistance, setDistance);
            pc.printf("leftSpeed:%f, rightSpeed:%f\r\n\r\n", leftSpeed, rightSpeed);
            //Stop();
            //while(sw2);
            //wait(1); 
            //Forward();
        }
        //****turn left
        //else ( rightDistance < (setDistance - 1)) 
        else
        {
            inc = 0.3f;
            leftSpeed = leftSpeed - inc;
            if(leftSpeed < 0.25f)
                leftSpeed = 0.25f;           
            left_pwm.write(leftSpeed);
            
            rightSpeed = rightSpeed + inc;
            if(rightSpeed > 0.65f)
                rightSpeed = 0.65f;
            right_pwm.write(rightSpeed);
            pc.printf("Turn Left,right distance:%d, %d\r\n", rightDistance, setDistance);
            pc.printf("leftSpeed:%f, rightSpeed:%f\r\n\r\n", leftSpeed, rightSpeed);
            //Stop();
            //while(sw2);
            //wait(1); 
            //Forward();
        }
        /*else
        {
            left_pwm.write(ileftSpeed);
            right_pwm.write(irightSpeed);
            pc.printf("Go Straight,right distance:%d, %d\r\n", rightDistance, setDistance);
            pc.printf("leftSpeed:%f, rightSpeed:%f\r\n\r\n", ileftSpeed, irightSpeed);
            //Stop();
            //while(sw2);
            //wait(1); 
            //Forward();
        }   */  
    EncoderIn.rise(&EncoderCount);  /*Interrupt: On rising edge of encoder tick*/ 
    wait(.05);
    }//end of while(1)
}//end of main()

        
void Wifi(void) 
{  
    unsigned int pastEntryID = 0,entryID = 0, posted = 0;
    pc.printf("\r\n******************Wifi Begin*********************************\r\n");     
    ConnectToServer();    //WIFI is used to communicate to Thingspeak servers//
    while(posted ==0)
    {
        pastEntryID = GetCurrentEntryID();
        if(pastEntryID > 0 && pastEntryID != 157 && pastEntryID <= 500)
            posted  = 1;
        else
            posted  = 0;
    }
    CloseConnection();
    pc.printf("\r\npastEntryID = %d", pastEntryID);  
    
    posted = 0; 
    while(posted == 0)
    {
        ConnectToServer();
        entryID = PostToServer();
        CloseConnection();
        if(entryID == pastEntryID + 1)
            posted = 1;
        else
            posted  = posted; 
       pc.printf("\r\ncurrent entryID = %d", entryID); 
       pc.printf("\r\npast entryID = %d", pastEntryID); 
       pc.printf("\r\nposted = %d", posted);
    }//while(posted ==0)
    pc.printf("\r\n******************Wifi Completed*********************************\r\n");
}//end of Wifi()

void ConnectToServer(void)
{   
    char snd[255],rcv[500];
    pc.printf("\r\n\r\n*************Sending WiFi information*************\r\n");
    
//Set Wifi to Single Channel Mode    
    pc.printf("\r\nSet WiFi into Single Channel mode\r\n");
    strcpy(snd,"AT+CIPMUX=0");//Setting WiFi into single Channel mode
    wifi.SendCMD(snd);
    //pc.printf(snd);
    wifi.RcvReply(rcv, 750);
    pc.printf("\r\nSingle Channel Mode Status: %s", rcv);
    //wait(1);

//Initiate connection with THINGSPEAK server 
    pc.printf("\r\nInitiating connection with ThinkSpeak sever\r\n");
    strcpy(snd,"AT+CIPSTART=\"TCP\",\"api.thingspeak.com\",80");    
    //pc.printf("\r\nsending: %s", snd);
    wifi.SendCMD(snd);
    wifi.RcvReply(rcv, 750);
    pc.printf("\r\nConnection Status: %s", rcv);
    
//Send Number of Characters to be sent
    pc.printf("\r\nSending Number of Characters to be sent");
    strcpy(snd,"AT+CIPSEND=110");    //Send Number of open connections,Characters to send 
    wifi.SendCMD(snd);
    //pc.printf(snd);
    wifi.RcvReply(rcv, 750);
    pc.printf("\r\nSent Status: %s", rcv);    
} //end of ConnectToServer()

unsigned int PostToServer(void)
{
    char snd[255],rcv[1000];
    unsigned int i = 0, len = 0, entryID1 = 0,entryID = 0;
    const int size = sizeof(rcv);
    //Post values to ThingSpeak
    pc.printf("\r\n\r\nPost Value to ThingSpeak\r\n");
    sprintf(snd,"GET https://api.thingspeak.com/update?key=1YAN0O31ADCV9MEP&field1=%d-%d HTTP/1.0\r\n\r\n",xvalue, yvalue);   //67,76,84
    //send 
    //pc.printf("\r\nSending: %s",snd);
    wifi.SendCMD(snd);
    wifi.RcvReply(rcv, 750);
    pc.printf("\r\nSent Status: %s", rcv);
    //send again
    //pc.printf("\r\nSending: %s",snd);
    wifi.SendCMD(snd);
    wifi.RcvReply(rcv, 750);
    pc.printf("\r\nSent Status: %s", rcv);
    
    for(i = 0; i <= size - 1; i++)
    {  
        if(rcv[i]==46 && rcv[i+1]==53 && rcv[i+2]==55 && rcv[i+9] ==0 && (rcv[i+10] ==0 || rcv[i+10] ==10)) //check for ".57"        
        { 
            if(rcv[i+8] ==0)
                len = 1;
            else
                len = 2;
                
            if(len==1)
                entryID1 = rcv[i+7]-48;
            else
                entryID1 = (rcv[i+7]-48)*10+(rcv[i+8]-48);
            //pc.printf("\r\nfound entryID: %d", entryID);
        }
        else
            i =i; 
        if(entryID1 > entryID)
            entryID = entryID1;
        else
            entryID = entryID;
    } //end of For loop
    pc.printf("\r\nfound entryID: %d", entryID);
    return entryID;  
}//end of PostToServer(); 

unsigned int GetCurrentEntryID(void)
{
    unsigned int i = 0, len = 0, currentEntryID = 0, entryID = 0; 
    char snd[255],rcv1[1000];
    const int size = sizeof(rcv1);
//Get values from ThinkSpeak
    pc.printf("\r\nGet Values from ThingSpeak\r\n");
    //strcpy(snd,"GET http://api.thingspeak.com/channels/104257/fields/1.json?key=1YAN0O31ADCV9MEP HTTP/1.0\r\n\r\n");//97 
    strcpy(snd,"GET http://api.thingspeak.com/channels/104257/status.json?key=1YAN0O31ADCV9MEP HTTP/1.0\r\n\r\n");//97 
    //send
    //pc.printf("\r\nSending: %s",snd);
    wifi.SendCMD(snd);
    wifi.RcvReply(rcv1, 750);
    pc.printf("\r\nSent Status: %s", rcv1);
    //send again
    //pc.printf("\r\nSending: %s",snd);
    wifi.SendCMD(snd);
    wifi.RcvReply(rcv1, 750);
    pc.printf("\r\nSent Status: %s", rcv1);  
    for(i = 0; i <= size - 1; i++)
    {  
        if(rcv1[i]==95 && rcv1[i+1]==105 && rcv1[i+2]==100) //check for "_id"  entry_id        
        { 
            if(rcv1[i+6] ==44)
                len = 1;
            else
                len = 2;
                
            if(len==1)
                entryID = rcv1[i+5]-48;
            else
                entryID = (rcv1[i+5]-48)*10+(rcv1[i+6]-48);
            //pc.printf("\r\nentry_id= %d", entryID);
        }
        else
            i=i;
            
        if(entryID > currentEntryID)
            currentEntryID = entryID;
        else
            currentEntryID = currentEntryID;
    } //end of For loop
    pc.printf("\r\nentry_id= %d", currentEntryID);
    return currentEntryID;
} //end of GetCurrentEntryID

void CloseConnection(void)
{
    char snd[255],rcv[500];
    //close connection   
    pc.printf("\r\nClose the Connection\r\n");                                   
    strcpy(snd,"AT+CIPCLOSE");        //closing the connection with thingspeak server
    wifi.SendCMD(snd);   
    //pc.printf("\r\nSending: %s",snd);  
    wifi.RcvReply(rcv, 750);
    pc.printf("\r\nClose Connection Status: %s", rcv);
         
    pc.printf("\r\nEnd of Closed Connection Response\r\n\r\n");
}//void connection


int GetFrontDistance(void)
{
    int distance = 0; 
    HCSR04 sensor(D4, D5);
    distance = sensor.distance();
    return distance;
}

int GetRightDistance(void)
{
    int distance = 0; 
    HCSR04 sensor(D2, D3);
    distance = sensor.distance();
    return distance; 
}

void Forward(void)
{
      right_cont1=0;
      right_cont2=1;
      left_cont1=0;
      left_cont2=1;
}

void Stop(void)
{
    right_cont1=0;
    right_cont2=0;
    left_cont1=0;
    left_cont2=0;
}

void Right90(void)
{
      right_cont1=0;
      right_cont2=0;
      left_cont1=0;
      left_cont2=1;
}

void Left90(void)
{
      right_cont1=0;
      right_cont2=1;
      left_cont1=0;
      left_cont2=0;
}

void ThreatDetected(void)
{
    red = 0; //on
    pc.printf("\r\n\r\n          A Threat has been Detected\r\n");
    pc.printf("\r\n          Posting Coordinate: %d to Server\r\n", xvalue);
    EncoderIn.rise(NULL);  //disable EncoderIn inturrpt
    Stop(); //stop robot motors
    wait(10);  
    Wifi(); //send x,y coordinates 
    red = 1; //off
    green = 0; //on
    while(1); //wait forever
}

void EncoderCount()
{ 
    xvalue++;
    //yvalue++;
    //pc.printf("\r\nX: %d, Y: %d\r\n\r\n", xvalue, yvalue);
}


