/**
@file main.cpp
@brief Program implementation

*/
#include "main.h"

int main()
{
    PHY_PowerDown();
    //semihost_powerdown();
    pc.baud(9600);  ///sets baud rate
    timer.attach(&timerExpired,0.2); /// Sets the speed of the timer and attaches a function to run
    timer2.attach(&timer2Expired,1); /// Sets the speed of the timer and attaches a function to run
    timer3.attach(&timer3Expired,2); /// Sets the speed of the timer and attaches a function to run
    LogTog.rise(&logToggle); /// attaches a function to the rise of the LogTog button
    UnitTog.rise(&unitToggle); /// attaches a function to the rise of the UnitTog button
    VisTog.rise(&visToggle); /// attaches a function to the rise of the VisTog button
    pc.attach(&serialISR); /// attach serial ISR
    BLED.period(0.02);  ///sets the frequency of the Backlight at 50Hz
    BLED=BLEDLevel.read();  ///sets the brightness
    lcd.init(); ///initilizes the display
    introTune(); /// plays the intro tune
    lcd.printString("---+--+--+---",3,0);/// Displays an introduction message
    lcd.printString("Distance",18,1);
    lcd.printString("Sensor",25,2);
    lcd.printString("By Jakobi",16,3);
    lcd.printString("Blackburn",16,4);
    lcd.printString("---+--+--+---",3,5);
    wait(2);
    lcd.clear(); /// clears the opening message
    while(1) {
        if (setTimeFlag) { /// if updated time has been sent
            setTimeFlag = 0; /// clear flag
            setTime(); /// update time
        }
        if(distance>=100) { /// uses the 2 second timer if the distance is above 100
            if(timer3Flag) { /// 2 second timer's flag
                pc.printf("Scan Speed = 0.5 \n"); /// prints the scan speed across the serial port
                theMain(); /// Contains the main code

            }
        } else if(distance>=50) { /// uses the 1 second timer if the distance is above 50 and less than 100
            if(timer2Flag) {/// 1 second timer's flag
                pc.printf("Scan Speed = 1 \n"); /// prints the scan speed across the serial port
                theMain(); /// Contains the main code
            }
        } else if(distance<50) { /// uses the 0.2 second timer if the distance is less than 50
            if(timerFlag) {/// 0.2 second timer's flag
                pc.printf("Scan Speed = 5 \n"); /// prints the scan speed across the serial port
                theMain(); /// Contains the main code
            }
        } else { /// otherwise
            error(1); /// displays an error message across the mBed leds
        }

        Sleep();/// Whilst the code is not doing anything else, it will sleep
    }
}

void timerExpired()
{
    timerFlag=1; /// sets the timer flag high
}

void timer2Expired()
{
    timer2Flag=1;/// sets the timer flag high
}
void timer3Expired()
{
    timer3Flag=1;/// sets the timer flag high
}

void theMain()
{
    BLED=BLEDLevel.read();  ///sets the brightness
    timerFlag =0; ///resets the timer flags
    timer2Flag=0;
    timer3Flag=0;
    time_t seconds = time(NULL); /// gets the current time
    /// formats that time into a string (time and date)
    strftime(buffer, 30 , "%d/%m/%y %R", localtime(&seconds));
    strftime(Gbuffer, 30 , "%R", localtime(&seconds));
    float dist = getDistance()*unitX; ///reads the distance and sets it to a float value.
    ///prints the value to the serial port.
    if(state==1) { 
        pc.printf("%s , Distance = %.2f %s \n",buffer,dist,units);
    } else if(state !=1) {
        pc.printf("%s , Distance = %.0f %s \n",buffer,dist,units);
    }
    logging(buffer,distance); /// runs the logging function
    if(visual==0) { /// if the visual toggle is set in the first mode,
        LCDVis0(); /// runs the first Visual function, Changing the Display
    } else if(visual==1) {/// if the visual toggle is set in the second mode,
        LCDVis1(); /// runs the second Visual function, Changing the Display
    } else if(visual==2) {/// if the visual toggle is set in the third mode,
        LCDVis2(); /// runs the third Visual function, Changing the Display
    } else if(visual==3) {/// if the visual toggle is set in the forth mode,
        LCDVis3(); /// runs the forth Visual function, Changing the Display
    } else if(visual==4) {/// if the visual toggle is set in the forth mode,
        LCDVis4(); /// runs the forth Visual function, Changing the Display
    }else { /// if there is no Visual mode selected then
        error(2); /// there is an error and so the error function runs
    }
}


void warnings()
{
    WLED=1;/// Warning LED is turned on
    volume= BuzVol.read(); /// sets the volume of the buzzer
    if(distance<20) { /// if the distance is less than 20 cm
        Buzzer.ContNote(1000.0, volume); /// uses the new member to create a continuous note
        ///(new member was written and added to speaker.h)
        
    } else {/// if the distance isnt less than 20
        Buzzer.PlayNote(1000.0, 0.1, volume);/// plays a note for 0.1 seconds
        WLED=0;/// and turns off the warning LED (creating a beep and a flash)
    }
}

float getDistance()
{
    int dist0 = sensor.getDistanceCm(); /// gets the distance 10 times
    int dist1 = sensor.getDistanceCm();
    int dist2 = sensor.getDistanceCm();
    int dist3 = sensor.getDistanceCm();
    int dist4 = sensor.getDistanceCm();
    int dist5 = sensor.getDistanceCm();
    int dist6 = sensor.getDistanceCm();
    int dist7 = sensor.getDistanceCm();
    int dist8 = sensor.getDistanceCm();
    int dist9 = sensor.getDistanceCm();
    distance=(dist0+dist1+dist2+dist3+dist4+dist5+dist6+dist7+dist8+dist9)/10;/// averages those distances

    warnings(); /// runs the warnings function
    return distance; /// returns the average distance
}

void unitToggle()
{
    state = fsm[state].nextState[UnitTog]; /// reads the input and updates the current state
    unitX = fsm[state].unitMultiple; /// sets the unit multiple depending on the current state
    units= fsm[state].Unit; /// sets the unit depending on the current state
    wait(0.2);
    pc.printf("unit multiple = %.2f \n",unitX);
    pc.printf("Units = %s \n",units);
}


void error(int E) /// has up to 14 possible errors. 
{ ///If a 15 is shown it is a ack bit error for the SRF02
    while(1) { /// loops flashing the error number on the onboard LED's 
        leds=0;
        wait(0.2);
        leds=E;
        wait(0.2);
    }
}

void logToggle()
{
    logButtonFlag = !logButtonFlag; ///flips the flag
    if(logButtonFlag) { /// if flag is high the device is logging so
        LLED=1; /// Logging LED will be on 
        pc.printf("-------\n Data Logging\n\r");/// prints a message to the serial port
    } else { /// if flag is low the device isn't logging so
        LLED=0; /// Logging LED is turned off 
        pc.printf("-------\n Stopped Logging Data\n\r");/// prints a message to the serial port
    }
    wait(0.2);
}

void logging(char* data,float data1)
{
    if(logButtonFlag) { //if the logging flag is high
        FILE *fp = fopen("/local/log.csv", "a"); /// opens 'log.csv' for appending
        /// if the file doesn't exist it is created, if it exists, data is appended to the end
        fprintf(fp," %s , %.2f\n ",data,data1); /// print string to file
        fclose(fp); /// close file
        pc.printf("Data Logged\n");/// prints a message to the serial port
        LLED=1; /// keeps the led on if it is logging
    } else {/// otherwise
        pc.printf("WARNING : Unlogged Data\n");/// prints a message to the serial port
        LLED=0; ///sets the logging LED to off
    }
}

void setTime()
{
/// prints Unix time for debugging
    pc.printf("\n \r Unix set time - %s\n",rxString);
/// atoi() converts a string to an integer
    int time = atoi(rxString);
/// update the time
    set_time(time);
    pc.printf("Set time - %s \n \r ",buffer);///prints the time to the serial port
}
void serialISR()
{
/// when a serial interrupt occurs, read rx string into buffer
    pc.gets(rxString,16);
/// set flag
    setTimeFlag = 1;
}

void introTune()
{/// plays several notes to create a tune
    Buzzer.PlayNote(1319.0,0.084,1.0);
    wait(0.01);
    Buzzer.PlayNote(1319.0,0.084,1.0);
    wait(0.094);
    Buzzer.PlayNote(1319.0,0.084,1.0);
    wait(0.094);
    Buzzer.PlayNote(1047.0,0.084,1.0);
    wait(0.01);
    Buzzer.PlayNote(1319.0,0.084,1.0);
    wait(0.094);
    Buzzer.PlayNote(1568.0,0.084,1.0);
    wait(0.26);
    Buzzer.PlayNote(784.0,0.084,1.0);
}


void LCDVis0()    /// the max range is 249 (according to the data sheet) 
{///and there are 84 pixels wide on the LCD so this can be used to map the amount of cm for each pixel
    lcd.clear();/// clears the screen
    if(logButtonFlag) { /// if the logging flag is high
        lcd.printString("-L-",0,5); /// prints an L onto the botton left of the screen
    }
    
    int I = distance*0.337;  /// and then multiplies the current distance by that value as (84/249) =0.337...
    I=I+3;
    if(I>=79){I=79;}
    pc.printf("bar width - %d pixels \n",I);/// prints the width to the serial port
    lcd.drawRect(0,16,83,16,0); ///draws a frame for the bar
    lcd.drawRect(2,18,I,12,1); /// draws a rectangle inside the frame at the calculated width
    if(state==1) {
        sprintf(Dbuffer, "%.2f", distance*unitX);   /// prints the value to the serial port.
    } else if(state !=1) {
        sprintf(Dbuffer, "%.0f", distance*unitX);   
    }
    lcd.printString (buffer,0,0);/// prints the time and date at the top of the screen
    lcd.printString (Dbuffer,26,5); /// prints the distance
    lcd.printString (units,50,5); /// and the units
    lcd.refresh();/// it then refreshes the screen
}

void LCDVis1()  /// the max range is 249 (according to the data sheet) 
{///and there are 48 pixels high on the LCD so this can be used to map the amount of cm for each pixel
    lcd.clear(); /// clears the screen
    if(logButtonFlag) {/// if the logging flag is high
        lcd.printString("-L-",0,5);/// prints an L onto the botton left of the screen
    }
    
    int J = distance*0.14;  /// and then multiplies the current distance by that value as (36/249) = 0.14..(as top 12 pixels are for time)
    if(J>=36) {
        J=36;
    }
    pc.printf("bar height - %d pixels \n",J);// prints the height to the serial port
    lcd.drawRect(24,9,34,38,0);///draws a frame for the bar
    lcd.drawRect(26,47-J,30,J-2,1);/// draws a rectangle inside the frame at the calculated height
    if(state==1) {
        sprintf(Dbuffer, "%.2f", distance*unitX);   /// prints the value to the serial port.
    } else if(state !=1) {
        sprintf(Dbuffer, "%.0f", distance*unitX);  
    }
    lcd.printString (buffer,0,0);/// prints the time and date at the top of the screen
    lcd.printString (Dbuffer,60,3);/// prints the distance
    lcd.printString (units,64,4);/// and the units
    lcd.refresh(); /// it then refreshes the screen
}

void LCDVis2()
{
    lcd.clear();/// clears the screen
    if(logButtonFlag) {/// if the logging flag is high
        lcd.printString("-L-",0,5);/// prints an L onto the botton left of the screen
    }
    car(); /// displays a small car shape
    int I = distance*0.277;  /// and then multiplies the current distance by that value as (69/249) =0.277...
    if(I>=84) {
        I=84;
    }
    pc.printf("bar width - %d pixels \n",I);
    lcd.drawRect(I+15,9,69,29,1); /// draws a rectangle inside the frame at the calculated width
    if(state==1) {
        sprintf(Dbuffer, "%.2f", distance*unitX);   /// prints the value to the serial port.
    } else if(state !=1) {
        sprintf(Dbuffer, "%.0f", distance*unitX);   /// prints the value to the serial port.
    }
    lcd.printString (buffer,0,0);/// prints the time and date at the top of the screen
    lcd.printString (Dbuffer,26,5);///prints the distance
    lcd.printString (units,50,5);///and the units
    lcd.refresh(); /// it then refreshes the screen
}
void LCDVis3()
{
    lcd.clear(); /// clears the screen
    if(logButtonFlag) {/// if the logging flag is high
        lcd.printString("-L-",0,5);/// prints an L onto the botton left of the screen
    }
    lcd.printString (buffer,0,0); ///prints the time and date
    int Dist=distance;                /// assigns each digit of the distance 
    if(state==0) {              /// to an integer and then depending on the value of that integer
        lcd.printString("CM",54,3); /// prints a large number to a position on the screen
    }                               /// (large numbers designed and added to the N5110 library)
    if(state==1) {
        lcd.decimal();
        lcd.printString("M",54,3);
    }
    if(state==2) {
        lcd.number0(57);
        lcd.printString("MM",73,3);
    }
    int S=Dist %10;
    pc.printf("singles - %d \n",S);
    if(S==0) {
        lcd.number0(38);
    } else if(S==1) {
        lcd.number1(38);
    } else if(S==2) {
        lcd.number2(38);
    } else if(S==3) {
        lcd.number3(38);
    } else if(S==4) {
        lcd.number4(38);
    } else if(S==5) {
        lcd.number5(38);
    } else if(S==6) {
        lcd.number6(38);
    } else if(S==7) {
        lcd.number7(38);
    } else if(S==8) {
        lcd.number8(38);
    } else if(S==9) {
        lcd.number9(38);
    } else {
        error(4);
    }

    int T=Dist/10 %10;
    pc.printf("tens - %d \n",T);
    if(T==0) {
        lcd.number0(19);
    } else if(T==1) {
        lcd.number1(19);
    } else if(T==2) {
        lcd.number2(19);
    } else if(T==3) {
        lcd.number3(19);
    } else if(T==4) {
        lcd.number4(19);
    } else if(T==5) {
        lcd.number5(19);
    } else if(T==6) {
        lcd.number6(19);
    } else if(T==7) {
        lcd.number7(19);
    } else if(T==8) {
        lcd.number8(19);
    } else if(T==9) {
        lcd.number9(19);
    } else {
        error(4);
    }
    int H=Dist/100 %10;
    pc.printf("Hundreds - %d \n",H);
    if(H==0) {
       if(state==1){ lcd.number0(0);}
    } else if(H==1) {
        lcd.number1(0);
    } else if(H==2) {
        lcd.number2(0);
    } else if(H==3) {
        lcd.number3(0);
    } else if(H==4) {
        lcd.number4(0);
    } else if(H==5) {
        lcd.number5(0);
    } else if(H==6) {
        lcd.number6(0);
    } else if(H==7) {
        lcd.number7(0);
    } else if(H==8) {
        lcd.number8(0);
    } else if(H==9) {
        lcd.number9(0);
    } else {
        error(4);
    }
    lcd.refresh();
}




void car()
{ /// sets pixels in the design of a car
    lcd.setPixel(4,19);lcd.setPixel(5,19);lcd.setPixel(6,19);lcd.setPixel(10,19);lcd.setPixel(11,19);lcd.setPixel(12,19);
    lcd.setPixel(4,20);lcd.setPixel(5,20);lcd.setPixel(6,20);lcd.setPixel(10,20);lcd.setPixel(11,20);lcd.setPixel(12,20);
    lcd.setPixel(1,21);lcd.setPixel(2,21);lcd.setPixel(3,21);lcd.setPixel(4,21);lcd.setPixel(5,21);lcd.setPixel(6,21);
    lcd.setPixel(7,21);lcd.setPixel(8,21);lcd.setPixel(9,21);lcd.setPixel(10,21);lcd.setPixel(11,21);lcd.setPixel(12,21);
    lcd.setPixel(13,21);lcd.setPixel(0,22);lcd.setPixel(1,22);lcd.setPixel(2,22);lcd.setPixel(3,22);lcd.setPixel(4,22);
    lcd.setPixel(6,22);lcd.setPixel(7,22);lcd.setPixel(8,22);lcd.setPixel(9,22);lcd.setPixel(10,22);lcd.setPixel(12,22);
    lcd.setPixel(13,22);lcd.setPixel(0,23);lcd.setPixel(1,23);lcd.setPixel(2,23);lcd.setPixel(3,23);lcd.setPixel(6,23);
    lcd.setPixel(7,23);lcd.setPixel(8,23);lcd.setPixel(9,23);lcd.setPixel(10,23);lcd.setPixel(12,23);lcd.setPixel(13,23);
    lcd.setPixel(0,24);lcd.setPixel(1,24);lcd.setPixel(2,24);lcd.setPixel(3,24);lcd.setPixel(6,24);lcd.setPixel(7,24);
    lcd.setPixel(8,24);lcd.setPixel(9,24);lcd.setPixel(10,24);lcd.setPixel(12,24);lcd.setPixel(13,24);lcd.setPixel(0,25);
    lcd.setPixel(1,25);lcd.setPixel(2,25);lcd.setPixel(3,25);lcd.setPixel(6,25);lcd.setPixel(7,25);lcd.setPixel(8,25);
    lcd.setPixel(9,25);lcd.setPixel(10,25);lcd.setPixel(12,25);lcd.setPixel(13,25);lcd.setPixel(0,26);lcd.setPixel(1,26);
    lcd.setPixel(2,26);lcd.setPixel(3,26);lcd.setPixel(4,26);lcd.setPixel(6,26);lcd.setPixel(7,26);lcd.setPixel(8,26);
    lcd.setPixel(9,26);lcd.setPixel(10,26);lcd.setPixel(12,26);lcd.setPixel(13,26);lcd.setPixel(1,27);lcd.setPixel(2,27);
    lcd.setPixel(3,27);lcd.setPixel(4,27);lcd.setPixel(5,27);lcd.setPixel(6,27);lcd.setPixel(7,27);lcd.setPixel(8,27);
    lcd.setPixel(9,27);lcd.setPixel(10,27);lcd.setPixel(11,27);lcd.setPixel(12,27);lcd.setPixel(13,27);lcd.setPixel(4,28);
    lcd.setPixel(5,28);lcd.setPixel(6,28);lcd.setPixel(10,28);lcd.setPixel(11,28);lcd.setPixel(12,28);lcd.setPixel(4,29);
    lcd.setPixel(5,29);lcd.setPixel(6,29);lcd.setPixel(10,29);lcd.setPixel(11,29);lcd.setPixel(12,29);
}

void visToggle()
{
    lcd.init();
    Vstate = Vfsm[Vstate].nextState[VisTog]; /// read input and update current state
    visual = Vfsm[Vstate].visual; /// set output depending on current state
    wait(0.2);
    if(visual==0) {
        pc.printf("----Left to Right----\n\r"); /// prints to the serial which mode is selected
    }
    if(visual==1) {
        pc.printf("----Up to Down----\n\r");
    }
    if(visual==2) {
        pc.printf("----Car & Wall----\n\r");
    }
    if(visual==3) {
        pc.printf("----Numbers----\n\r");
    }
}
int semihost_powerdown(){
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}

void LCDVis4()
{
    lcd.clear();/// clears the screen
    if(logButtonFlag) {/// if the logging flag is high
        lcd.printString("-L-",36,0);/// prints an L onto the botton left of the screen
    }
    int J = distance*0.14;  /// and then multiplies the current distance by that value as (36/249) = 0.14..
    if(J>39) {                                                  ///(as top 12 pixels are for time)
        J=39; /// limits the value so that it leaves space at the top for the distance
    }
    array[83]= J; /// sets the latest plot into the array
    for (int i=0; i<84; i++) {  /// loops through the array
        lcd.setPixel(i,48 - array[i]); ///setting the plots. as 0,0 is top left so must be taken from 47
        for(int fill=47; fill>(48 - array[i]); fill--){
            lcd.setPixel(i,fill);// then filling the whole line from the plot to the bottom of the screen
        }
    } 
        for (int i=83; i>-1; i--) {  /// loops through the array
        PrevArray[i]= array[i];
        array[i]=PrevArray[i+1];
        }
    if(state==1) {
        sprintf(Dbuffer, "%.2f", distance*unitX);   /// prints the value to the serial port.
    } else if(state !=1) {
        sprintf(Dbuffer, "%.0f", distance*unitX); 
    }
    lcd.printString (Gbuffer,55,0);/// prints the time at the top of the screen
    lcd.printString (Dbuffer,0,0);///prints the distance
    lcd.printString (units,24,0);///and the units
    lcd.refresh(); /// it then refreshes the screen
}