#include "mbed.h"
#include "USBHostXpad.h"

Serial pc(USBTX, USBRX);
DigitalOut led(LED1);
volatile int poll = 0;
/**
@namespace AXYB
@brief Integer for storing the hex of the A X Y B buttons
@brief XPad returns a 4 digit hex for all buttons- AXYB buttons are stored in first value
@param A - given as a 1
@param B - given as a 2
@param X - given as a 4
@param Y - given as a 8
*/
uint8_t AXYB=0x0;
/**
@namespace XLBRB
@brief Integer for storing the hex of the LB,RB and center X buttons
@brief XPad returns a 4 digit hex for all buttons- AXYB buttons are stored in second value
@param LB - given as a 1
@param R - given as a 2
@param X - given as a 4

*/
uint8_t XLBRB=0x0;

/**
@namespace bkStrtLCRC
@brief Integer for storing the hex of the Left analog button,Right analog button,back and start buttons
@brief XPad returns a 4 digit hex for all buttons- AXYB buttons are stored in third value
@param start - given as a 1
@param back - given as a 2
@param LC - given as a 4
@param RC - given as a 8
*/
uint8_t bkStrtLCRC=0x0;
/**
@namespace DPad
@brief Integer for storing the hex of the Directional buttons
@brief XPad returns a 4 digit hex for all buttons- AXYB buttons are stored in fourth value
@param Up - given as a 1
@param Down - given as a 2
@param Left - given as a 4
@param Right - given as a 8
*/
uint8_t DPad=0x0;
/**
@namespace LSY
@brief float for storing the value of the Left Analogue Stick's Y axis
@brief XPad returns a value between -32768(down) and 32767(up)
@there is a deadzone between around -4000 and 4000 where the value returned is not consistent when in the fixed position(assummed 0,0 point)
*/
float LSY=0x0;
/**
@namespace LSX
@brief float for storing the value of the Left Analogue Stick's X axis
@brief XPad returns a value between -32768(left) and 32767(right)
@there is a deadzone between around -4000 and 4000 where the value returned is not consistent when in the fixed position(assummed 0,0 point)
*/
float LSX=0x0;
/**
@namespace RSY
@brief float for storing the value of the Right Analogue Stick's Y axis
@brief XPad returns a value between -32768() and 32767(up)
@there is a deadzone between around -4000 and 4000 where the value returned is not consistent when in the fixed position(assummed 0,0 point)
*/
float RSY=0x0;
/**
@namespace RSX
@brief float for storing the value of the Right Analogue Stick's X axis
@brief XPad returns a value between -32768(left) and 32767(right)
@there is a deadzone between around -4000 and 4000 where the value returned is not consistent when in the fixed position(assummed 0,0 point)
*/
float RSX=0x0;
/**
@namespace sN
@brief float for storing the stick Normalising value
@brief makes the range of the sticks -10 to 10
*/
const float sN=0.000305175781;//(10/32768)
/**
@namespace Lt
@brief float for storing the value of the Left trigger
@brief XPad returns a value between 0(not pressed) and 255(fully pressed)
@
*/
float Lt=0x0;
/**
@namespace Rt
@brief float for storing the value of the Left trigger
@brief XPad returns a value between 0(not pressed) and 255(fully pressed)
@
*/
float Rt=0x0;
/**
@namespace tN
@brief float for storing the trigger Normalising value
@brief makes the range of the triggers 0 to 10
*/
const float tN=0.03921568627;//(10/255)

void XpadValues(int buttons, int stick_lx, int stick_ly, int stick_rx, int stick_ry, int trigger_l, int trigger_r){
    std::printf("Xpad: %04x %-5d %-5d %-5d %-5d %d %d\r\n", buttons, stick_lx, stick_ly, stick_rx, stick_ry, trigger_l, trigger_r);//%04x makes it display (hex) 0 as 0000 %02x
    std::printf("buttons: %04x\r\n",buttons);
    std::printf("AXYB: %x\r\n",AXYB);
    std::printf("XLBRB: %x\r\n",XLBRB);
    std::printf("bkStrtLCRC: %x\r\n",bkStrtLCRC); 
    std::printf("Dpad: %x\r\n",DPad);
    std::printf("LSY: %.2f\r\n",LSY);
    std::printf("LSX: %.2f\r\n",LSX);
    std::printf("RSY: %.2f\r\n",RSY);
    std::printf("RSX: %.2f\r\n",RSX);
    std::printf("Lt: %.2f\r\n",Lt);
    std::printf("Rt: %.2f\r\n",Rt); 
}


void onXpadEvent (int buttons, int stick_lx, int stick_ly, int stick_rx, int stick_ry, int trigger_l, int trigger_r) {    
    AXYB=buttons>>12;
    XLBRB=(buttons&0x0f00)>>8;
    bkStrtLCRC=(buttons&0x00f0)>>4;
    DPad=buttons&0x000f;
    LSY=stick_ly*sN;
    LSX=stick_lx*sN;
    RSY=stick_ry*sN;
    RSX=stick_rx*sN;
    Lt=trigger_l*tN;
    Rt=trigger_r*tN;
    XpadValues(buttons, stick_lx, stick_ly, stick_rx, stick_ry, trigger_l, trigger_r);
    poll = 0;
}

void xpad_task(void const *) {
    USBHostXpad xpad;

    while(1) {
        // try to connect a Xbox 360 Wireless Controller
        while(!xpad.connect())
            Thread::wait(500);
    
        // when connected, attach handler called on xpad event
        xpad.attachEvent(onXpadEvent);

        xpad.led(USBHostXpad::LED_ROTATE);
        Thread::wait(500);
        xpad.rumble(0xff, 0);
        Thread::wait(500);
        xpad.rumble(0, 0xff);
        Thread::wait(500);
        xpad.rumble(0, 0);
        Thread::wait(500);
        xpad.led(USBHostXpad::LED1_ON);

        // wait until the mouse is disconnected
        while(xpad.connected()) {
            Thread::wait(500);
            poll ++;
            if (poll > 10) {
                xpad.restart();
                poll = 0;
            }
        }
    }
}


int main() {
    pc.baud(9600);
    pc.printf("----------\r\n");
    Thread xpadTask(xpad_task, NULL, osPriorityNormal, 1024 * 4);
    while(1) {
       // led=!led;
      //  Thread::wait(500);
    }
}

