#include "spi.h"

SPI device(SPI_MOSI, SPI_MISO, SPI_SCK);
 
//SPI Init Code,visit SD Card/W25Q64/NRF24L01						  
//SPI PIN Init
void SPI_Init(void)
{	 

	//SPI2 clock frequence less than 36Mhz
	SPI.frequency(36000000/256);
	SPI_ReadWriteByte(0xff);//start transfer
}   


//SPI Speed Setting 
//SpeedSet:0~7
//SPI Speed = fAPB1/2^(SpeedSet+1)
//APB1 clock usually is 36Mhz
void SPI_SetSpeed(uint8_t SpeedSet)
{
	SpeedSet&=0X07;			//limit
	SPI->CR1&=0XFFC7; 
	SPI->CR1|=SpeedSet<<3;	//setting SPI speed
	SPI->CR1|=1<<6; 		//SPI device enabled 
} 


//SPI readWrite a Byte
//TxData:the data to write
//return:the data read back
u8 SPI_ReadWriteByte(uint8_t TxData)
{		
	u16 retry=0;				 
	while((SPI->SR&1<<1)==0)		//waiting sending array is empty
	{
		retry++;
		if(retry>=0XFFFE)return 0; 	//out of time quit
	}			  
	SPI->DR=TxData;	 	  		//send one byte
	retry=0;
	while((SPI->SR&1<<0)==0) 		//waiting received a byte
	{
		retry++;
		if(retry>=0XFFFE)return 0;	//out of time quit
	}	  						    
	return SPI->DR;          		//return the data read	    
}








