/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
and associated documentation files (the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "mbed.h"
#include "ble/BLE.h"
#include "RGBLED.h"

#define TXRX_BUF_LEN                     20


BLE             ble;

ChainableLED    leds(P0_11, P0_9, P0_10,1);
//Serial pc(USBTX, USBRX);


// The Nordic UART Service
static const uint16_t mesh_base_uuid       = 0xFEE4;
static const uint8_t mesh_metadata_uuid[]   = {0x2A, 0x1E, 0x00, 0x04, 0xFD, 0x51, 0xD8, 0x82, 0x8B, 0xA8, 0xB9, 0x8C, 0x00, 0x00, 0xCD, 0x1E};
static const uint8_t mesh_value_uuid[]      = {0x2A, 0x1E, 0x00, 0x05, 0xFD, 0x51, 0xD8, 0x82, 0x8B, 0xA8, 0xB9, 0x8C, 0x00, 0x00, 0xCD, 0x1E};


uint8_t metadataPayload[TXRX_BUF_LEN] = {0,};
uint8_t valuePayload[TXRX_BUF_LEN] = {0,};

static uint8_t advData[14]={0x07,0x16,0xE4,0xFE,0,0,0,0,0,0,0,0,0,0};

//static uint8_t rx_buf[TXRX_BUF_LEN];
//static uint8_t rx_len=0;


GattCharacteristic  metadataCharacteristic (mesh_metadata_uuid, metadataPayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
                                      
GattCharacteristic  valueCharacteristic (mesh_value_uuid, valuePayload, 1, TXRX_BUF_LEN, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE | GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE| GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY);
                                      
GattCharacteristic *meshChars[] = {&metadataCharacteristic, &valueCharacteristic};

GattService         meshService(mesh_base_uuid, meshChars, sizeof(meshChars) / sizeof(GattCharacteristic *));



void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    //pc.printf("Disconnected \r\n");
    //pc.printf("Restart advertising \r\n");
    ble.gap().startAdvertising();
}

void WrittenHandler(const GattWriteCallbackParams *Handler)
{   
    uint8_t buf[TXRX_BUF_LEN];
    uint16_t bytesRead;
    
    if (Handler->handle == valueCharacteristic.getValueAttribute().getHandle()) 
    {


    }
}


void scanCallBack(const Gap::AdvertisementCallbackParams_t *report)
{
    /*uint8_t index;
    pc.printf("BLE scan \r\n");
    pc.printf("The ADV data: ");
    for(index=0; index<report->advertisingDataLen; index++)
    {
        pc.printf("%x ", report->advertisingData[index]);
    
    }        
    pc.printf(" \r\n");*/
    
    if((report->advertisingData[2] ==  0x0D)&&(report->advertisingData[3] == 0x16)&&(report->advertisingData[4] == 0xE4)&&(report->advertisingData[5] == 0xFE))
    {
            
        //if(memcmp(report->advertisingData,client_adv_temp,sizeof(report->advertisingData)) != 0)
        {
            if((advData[8]==report->advertisingData[10])&&(advData[9]==report->advertisingData[11])&&(advData[10]==report->advertisingData[12])&&(advData[11]==report->advertisingData[13])&&(advData[12]==report->advertisingData[14])&&(advData[13]==report->advertisingData[15]))
            {
              //Serial.println("same data");
              return;
            }
            //memcpy(advdata_temp,report->advertisingData,report->advDataLen);
            if(report->advertisingData[10] ==  0x03)
            {
                ble.stopScan();
                memset(advData,0,sizeof(advData));
                for(uint8_t i = 0;i<14;i++)
                {
                    advData[i]=report->advertisingData[i+2];
                }
                
                /*for(index=0; index<report->advertisingDataLen-2; index++)
                {
                    pc.printf("%x ", advData[index]);
                
                }        
                pc.printf(" \r\n");  */  
                leds.setColorRGB(0, report->advertisingData[13], report->advertisingData[14], report->advertisingData[15]);  
                ble.clearAdvertisingPayload();
                ble.accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA,advData,14);
                ble.startAdvertising();
                wait_ms(50);
                ble.stopAdvertising();
                ble.startScan(scanCallBack);
            }
            
        }
    }
    else if((report->advertisingData[2] ==  0x07)&&(report->advertisingData[3] == 0x16)&&(report->advertisingData[4] == 0xE4)&&(report->advertisingData[5] == 0xFE))
    {
        /*for(index=0; index<14; index++)
        {
            pc.printf("%x ", advData[index]);
        
        } 
        pc.printf(" \r\n");*/
        ble.stopScan();
      
        ble.accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA,advData,14);
        ble.startAdvertising();
        wait_ms(50);
        ble.stopAdvertising();
        ble.startScan(scanCallBack);
        
    }


}


void m_status_check_handle(void)
{   

}


int main(void)
{   
    Ticker ticker;
    ticker.attach_us(m_status_check_handle, 200000);
    
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(WrittenHandler);  
    
    //pc.baud(9600);
    //pc.printf("SimpleChat Init \r\n");

    
    // setup advertising 
    ble.accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA,advData,14);
                                    
    // 100ms; in multiples of 0.625ms. 
    ble.setAdvertisingInterval(60);

    ble.addService(meshService);
    
    ble.startAdvertising(); 
    
    //pc.printf("Advertising Start \r\n");
    ble.setScanParams(60,0x30);
    ble.startScan(scanCallBack);

    
    //pc.printf("Advertising Start \r\n");
    
    while(1)
    {
        ble.waitForEvent(); 
    }
}































