#include "mbed.h"
#include "SimpleSpirit1.h"

//      Rf variables

static uint8_t txDataXYZ[6];
static SimpleSpirit1 &myspirit = SimpleSpirit1::CreateInstance(PC_12,PC_11, PC_10, PE_5, PB_5, PB_15); /* mosi,miso,sclk,irq,cs,sdn*/ 
static volatile bool tx_done_flag = false; 
static volatile bool send_data_flag = false;        
static InterruptIn event(PA_2); 

//      Sensor variables

SPI device(D11, D12, D13);                                                      // mosi, miso, sclk,ssel
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut cs (PB_2);

static bool flag=0;
static uint16_t new_data=0;
static uint16_t in_threshold=0x1e0f;                                             // inactivity threshold level
static uint16_t dur_threshold=0x1f0f;
static uint16_t ctrl_1=0x203f;                                     
static uint16_t ctrl_2=0x2100;                                                  //HP filter disable
static uint16_t ctrl_3=0x2208;
static uint16_t ctrl_4=0x2304;
static uint16_t ctrl_5=0x2400;
//static unsigned char add_ctrl_6=0x2500;                                       // INT2
static uint16_t ctrl_7=0x2604;                                                  //Interrupt lached
static uint16_t status=0x2700;
static uint16_t out_x_l=0x2800;
static uint16_t out_x_h=0x2900;
static uint16_t out_y_l=0x2a00;
static uint16_t out_y_h=0x2b00;
static uint16_t out_z_l=0x2c00;
static uint16_t out_z_h=0x2d00;
static uint16_t fifo_ctrl=0x2e40;                                               //FIFO configuration
//static uint16_t fifo_src=0x2f00;                                              //FIFO status register  
static uint16_t ig_conf_1=0x300a;                                               //interrupt 1 configuration
static uint16_t ig_src_1=0x3100;                                                //Interrupt Status Register
static uint16_t threshold_x=0x3220;
static uint16_t threshold_y=0x3320;
static uint16_t threshold_z=0x3420;                                             //threshold level
static uint16_t ig_dur_1=0x3504;                                                //interrupt duration
//static unsigned char ig_conf_2=0x36;

static  uint32_t coda=0;
static unsigned char cont=0;

static InterruptIn event1(PA_2);

//      Rf function

static void send_data(void)                                                     //Funzione per mandare dati
{
  while(myspirit.is_receiving()); 
 
  size_t curr_len = strlen((const char*)txDataXYZ) + 1;
  myspirit.send(txDataXYZ, 6);  
}

//      Sensor function

static void toggle_on() {                                                       //Inizializzazione evento
    printf("Event Start\n");
    flag=1;
    coda=0;
    }

static void paket_send(uint16_t a){                                             //Funzione utilizzata per scrivere i dati nei registri del sensore
    cs=0;
    device.write(a);
    cs=1;
    }

static unsigned char read_data(uint16_t a){                                     //Funzione utilizzata per leggere i dati nei registri del sensore
    unsigned char temp_data;
    uint16_t temp_add;
    temp_add=0x8000+a;
    cs=0;
    temp_data=device.write(temp_add);
    cs=1;
    return temp_data;
    }

//      Main

int main() 
{  
    event1.rise(&toggle_on);
    device.format(16,3);
    
    cs=1;
    flag=1;
    myspirit.on();
    cont = read_data(ctrl_7);
    if(cont != 0x04){
        paket_send(in_threshold);
        paket_send(dur_threshold);
        paket_send(ctrl_1);
        paket_send(ctrl_2);
        paket_send(ctrl_3);
        paket_send(ctrl_4);
        paket_send(ctrl_5);
        paket_send(ctrl_7);
        paket_send(threshold_x);
        paket_send(threshold_y);
        paket_send(threshold_z);
        paket_send(fifo_ctrl);
        paket_send(ig_dur_1);
        paket_send(ig_conf_1);
        sleep();
    }  
  while(1) 
  { 
                                                                                // Accendo antenna
    while(flag){
        new_data=read_data(status);                                             // Lettura stato
        new_data=new_data&0x08;                                                 // Lettura bit new data 
        if(new_data==0x08){
            txDataXYZ[0]=read_data(out_x_h);
            txDataXYZ[3]=read_data(out_x_l);
            txDataXYZ[1]=read_data(out_y_h);
            txDataXYZ[4]=read_data(out_y_l);
            txDataXYZ[2]=read_data(out_z_h);
            txDataXYZ[5]=read_data(out_z_l);
            send_data();                                                        // Invio Dati
            coda++;
            if (coda>500){                                                      // Condizione uscita invio dati
                read_data(ig_src_1);
                }
            }        
        } 
   }
}