#include "mbed.h"
#include "SimpleSpirit1.h"
static int16_t rDataXYZ[3];
static uint16_t rxlDataXYZ[3];
static uint16_t rxhDataXYZ[3];
static uint8_t rxsDataXYZ[6];
static uint16_t tempbhi;
static uint16_t ris;
static uint16_t tempm;
static SimpleSpirit1 &myspirit = SimpleSpirit1::CreateInstance(PC_12,PC_11, PC_10, PE_5, PB_5, PB_15); /* mosi,miso,sclk,irq,cs,sdn*/
static volatile bool rx_done_flag = false; 
static DigitalOut TestLED(PA_5);
Serial pc(SERIAL_TX, SERIAL_RX);        
static void callback_func(int event) 
{          
    rx_done_flag = 1;
}
static void merge_data(void)                                                    //Funzione usata per mettere i dati in un array da 8 bit
{  
    for(int ss=0;ss<3;ss++){
        rxhDataXYZ[ss]=rxsDataXYZ[ss];
        }
    for(int sss=3;sss<6;sss++){
        rxlDataXYZ[sss-3]=rxsDataXYZ[sss];
        }   
    for(int s=0;s<3;s++){
        
        tempm = rxhDataXYZ[s] << 8;
        tempbhi= rxlDataXYZ[s];
        ris =tempm|tempbhi;
        rDataXYZ[s] = ris;
        }
    
}   

static void read_rcvd_data(void)                                                //Funzione utilizzata per leggere e visualizzare i dati
{
      int ret = myspirit.read(rxsDataXYZ, sizeof(rxsDataXYZ));                  // Lettura dati
      merge_data();
      TestLED = !TestLED;     
      pc.printf("%d %d %d\n ", rDataXYZ[0], rDataXYZ[1],rDataXYZ[2]); 
}

int main() 
{
  TestLED = 0;  
  pc.baud(38400);                                                               // BoudRate :1200, 2400, 4800, 9600, 19200, 38400, 57600,115200              
  myspirit.attach_irq_callback(callback_func); 
  myspirit.on();
   
  while(1) 
  {
    __WFE();
    if(rx_done_flag) 
    {
      read_rcvd_data();
      rx_done_flag = false;      
    }   
  }
}