#include "Map.h"

Map::Map()
:
// Instantiate the bitmap tile 
_tileImageBitmap(tileImage, 4, 4),
// Instantiate the bitmap level
_levelBackground(levelBackground, 48, 84),
_cols(21),
_rows(12)
    
{}

Map::~Map()
{
     
}

void Map::draw(N5110& lcd)
{
    // Draw the background first so the tilemap renders on top
    _levelBackground.render(lcd, 0, 0);
    
    // Calculate the screen pixel coordinate to draw the correct tile at
    for (int c = 0; c < _cols; c++)
    {
        for (int r = 0; r < _rows; r++)
        {
            if (this->getTile(c, r) != 0)
            {
                //printf("c %d\tr %d\n", c, r);
                // If the tile value is not 0, render a tile at the location
                _tileImageBitmap.render(lcd, c * tileSize, r * tileSize);
            }
        }
    }
}

int Map::getTile(int col, int row)
{
    // Return value of cell at the specifed col and row using row-major indexing
    // as from Alex Valavanis Bitmap library
    return tileMap[row * _cols + col];
}

/*
AABB Map::getAabbAtIndex(int col, int row)
{
    // Create an AABB struct
    AABB localAABB;
    
    // Store values of the AABB calculated from passed in col and row and the 
    // tiles size
    localAABB.min.x = col * tileSize;
    localAABB.max.x = (col * tileSize) + tileSize;
    localAABB.min.y = row * tileSize;
    localAABB.max.y = (row * tileSize) + tileSize;
    
    return localAABB;
}
*/

int Map::getMaxCol()
{
    return _cols;
}

int Map::getMaxRow()
{
    return _rows;
}

int Map::getTileSize()
{
    return tileSize;   
}




