/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "cc3000.h"
#include "main.h"
#include "NTPClient.h"

#define CC3000_IRQ   D3  // (D3)
#define CC3000_EN    D5  // (D5)
#define CC3000_CS    D10 // (D10)
#define CC3000_MOSI  D11 // (D11)
#define CC3000_MISO  D12 // (D12)
#define CC3000_SCLK  D13 // (D13)

#define SSID         "Prakjaroen"
#define PHRASE       "A4B5C6D7E8F9"
#define SECURITY     WPA2

#define IP           "192.168.2.165"
#define MASK         "255.255.255.0"
#define GW           "192.168.2.1"
#define DHCP         1

using namespace mbed_cc3000;

#if defined TARGET_NUCLEO_F446RE
//cc3000 wifi(IRQ, EN, CS, SPI(MOSI, MISO, SCLK), SSID, PHRASE, SECURITY, false);
cc3000 wifi(D3, D5, D10, SPI(D11, D12, D13), "Prakjaroen", "A4B5C6D7E8F9", WPA2, false);
Serial pc(USBTX, USBRX);
#endif

/**
 *  \brief NTP client demo
 *  \param  none
 *  \return int
 */
int main() {
    init(); /* board dependent init */
    pc.baud(230400);
    
    printf("\r\n--------------------------------------------------------------------------------\r\n");
    printf("cc3000 NTP client demo.\r\n");
#if (DHCP == 1)
    printf("Initialize the interface using DHCP...\r\n");
    printf("wifi.init() ");
    wifi.init();
#else
    printf("Initialize the interface using a static IP address...\r\n");
    printf("wifi.init(%s, %s, %s) ", IP, MASK, GW);
    wifi.init(IP, MASK, GW);
#endif
    printf("done.\r\n");
    printf("wifi.connect() ");
    if (wifi.connect() == -1) {
        printf("failed.\r\n");
        printf("Failed to connect. Please verify connection details and try again. \r\n");
    } else {
        printf("done.\r\n");
        printf("IP address: %s \r\n", wifi.getIPAddress());
    }

    NTPClient ntp_client;
    time_t ct_time;
    char time_buffer[80];    
    char time_buffer_old[80];    
    wait(1);

    strcpy(time_buffer_old, "");

    // Parameters
    char* domain_name = "0.uk.pool.ntp.org";
    int   port_number = 123;
    
    // Read time from server
    printf("Reading time...\r\n");
    ntp_client.setTime(domain_name, port_number);

//    ct_time = time(NULL);
//    strftime(time_buffer, 80, "%a %b %d %T %p %z %Z\n", localtime(&ct_time));
//    printf("UTC/GMT: %s\n", time_buffer);
//    printf("UTC %s\n", ctime(&ct_time));

    // Choose standard or daylight savings time, comment out other
//    ct_time= time(NULL) + 3600; // Winter time - Convert to Europe/Amsterdam Time
    ct_time = time(NULL) + 7200; // Summer time - Convert to Europe/Amsterdam Time
    set_time(ct_time);

//    ct_time = time(NULL);
    strftime(time_buffer, 80, "%a %d-%b-%Y %T", localtime(&ct_time));
    printf("%s\r\n", time_buffer);

    while (1) {
        ct_time = time(NULL);
        strftime(time_buffer, 80, "%S", localtime(&ct_time));
        if (strcmp(time_buffer, time_buffer_old) != 0) {
            strcpy(time_buffer_old, time_buffer);
            strftime(time_buffer, 80, "%a %d-%b-%Y %T", localtime(&ct_time));
            printf("%s\r\n", time_buffer);
            // Sync ones a day
            strftime(time_buffer, 80, "%T", localtime(&ct_time));
            if (strcmp(time_buffer, "00:00:00") == 0) {
                ntp_client.setTime(domain_name, port_number);
            }
        }
    }
}

