/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "main.h"
#include "mbed.h"

#if defined (TARGET_NUCLEO_F446RE)
    #include "NVIC_set_all_priorities.h"
    void init() {
        NVIC_set_all_irq_priorities(3);
        NVIC_SetPriority(SPI1_IRQn, 0x0);     // Wi-Fi SPI interrupt must be higher priority than SysTick
        NVIC_SetPriority(EXTI3_IRQn, 0x1);    // PB3 interrupt
        NVIC_SetPriority(SysTick_IRQn, 0x2);  // SysTick set to lower priority than Wi-Fi SPI bus interrupt
    }
#endif
