#include "WDT.h"

// Load timeout value in watchdog timer and enable
void WDT::Configure(float timeout) {

#ifdef LPC    
    LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
    uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
    LPC_WDT->WDTC = (uint32_t)(timeout * (float)clk);
    LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
#endif   
#ifdef ST_NUCLEO
    // see http://embedded-lab.com/blog/?p=9662    
    #define LsiFreq (45000)
    
    uint16_t PrescalerCode;
    uint16_t Prescaler;
    uint16_t ReloadValue;
//    float timeout = 10;
    float Calculated_timeout;

    if ((timeout * (LsiFreq/4)) < 0x7FF) {
        PrescalerCode = IWDG_PRESCALER_4;
        Prescaler = 4;
    }
    else if ((timeout * (LsiFreq/8)) < 0xFF0) {
        PrescalerCode = IWDG_PRESCALER_8;
        Prescaler = 8;
    }
    else if ((timeout * (LsiFreq/16)) < 0xFF0) {
        PrescalerCode = IWDG_PRESCALER_16;
        Prescaler = 16;
    }
    else if ((timeout * (LsiFreq/32)) < 0xFF0) {
        PrescalerCode = IWDG_PRESCALER_32;
        Prescaler = 32;
    }
    else if ((timeout * (LsiFreq/64)) < 0xFF0) {
        PrescalerCode = IWDG_PRESCALER_64;
        Prescaler = 64;
    }
    else if ((timeout * (LsiFreq/128)) < 0xFF0) {
        PrescalerCode = IWDG_PRESCALER_128;
        Prescaler = 128;
    }
    else {
        PrescalerCode = IWDG_PRESCALER_256;
        Prescaler = 256;
    }
    
    // specifies the IWDG Reload value. This parameter must be a number between 0 and 0x0FFF.
    ReloadValue = (uint32_t)(timeout * (LsiFreq/Prescaler));
    
    Calculated_timeout = ((float)(Prescaler * ReloadValue)) / LsiFreq;
//    printf("WATCHDOG set with prescaler:%d reload value: 0x%X - timeout:%f\n",Prescaler, ReloadValue, Calculated_timeout);

    IWDG->KR = KR_REG_ACCESS_VAL; //Disable write protection of IWDG registers      
    IWDG->PR = PrescalerCode;      //Set PR value      
    IWDG->RLR = ReloadValue;      //Set RLR value      
    IWDG->KR = KR_KEY_RELOAD_VAL;    //Reload IWDG      
    IWDG->KR = KR_KEY_ENABLE_VAL;    //Start IWDG - See more at: http://embedded-lab.com/blog/?p=9662#sthash.6VNxVSn0.dpuf  
#endif

    Service();
}

// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
void WDT::Service() {
#ifdef LPC    
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
#endif    
#ifdef ST_NUCLEO
    IWDG->KR = KR_KEY_RELOAD_VAL;         //Reload IWDG - See more at: http://embedded-lab.com/blog/?p=9662#sthash.6VNxVSn0.dpuf
#endif
}

//    bool WDT::WatchdogCausedReset() {
//        return wdreset;
//    }
 

