#include "mbed.h"
#include "HSV.h"
#include "RGB_Matrix.h"
#include "Arial8x8.h"
#include "Arial12x12.h"
#include "HD44780_6x8.h"

#define  PIN_R1   D14
#define  PIN_R2   D15
#define  PIN_G1   D2
#define  PIN_G2   D3
#define  PIN_B1   D4
#define  PIN_B2   D5
#define  PIN_CLK  D6
#define  PIN_LAT  D7
#define  PIN_OE   D8
#define  PIN_A    D9
#define  PIN_B    D10
#define  PIN_C    D11
#define  PIN_D    D12

#define  PI  3.1415926536

AnalogIn analog_value(A0);

DigitalOut led1(LED1);
DigitalIn button(PC_13);

Ticker flipper;
HSV Hsv;

RGB_Matrix MyMatrix(PIN_R1, PIN_R2, PIN_G1, PIN_G2, PIN_B1, PIN_B2, PIN_CLK, PIN_LAT, PIN_OE, PIN_A, PIN_B, PIN_C, PIN_D);

void flip()
{
    led1 = !led1;
}

int main() {
    printf("\nRGB Matrix example\n");

    flipper.attach(&flip, 0.5); // the address of the function to be attached (flip) and the interval (0.5 seconds)

    MyMatrix.Init();
    MyMatrix.SetOrientation(LANDSCAPE_B);
    MyMatrix.set_font((unsigned char*) HD44780_6x8);
//    MyMatrix.character(1, 1, '3');
//    MyMatrix.printstring("0123456789");

//    MyMatrix.foreground(RGB(255,64,0));
//    MyMatrix.printstring("The quick brown fox jumps over");

    MyMatrix.locate(0, 0);
//    MyMatrix.foreground(RGB(255,255,0));
    MyMatrix.foreground(RGB(255,128,64)); // Warm white
    MyMatrix.printStringCenter("10:25:36");


    MyMatrix.locate(0, 1);
//    MyMatrix.foreground(RGB(255,64,0));
//    MyMatrix.foreground(RGB(64,128,255));
    MyMatrix.printStringCenter("Donderdag");

    MyMatrix.locate(0, 2);
//    MyMatrix.foreground(RGB(255,128,0));
    MyMatrix.printStringCenter("01 Okt");

    MyMatrix.locate(0, 3);
    MyMatrix.locatePixelX(2);
//    MyMatrix.foreground(RGB(0,255,0)); // Green
//    MyMatrix.foreground(RGB(64,0,255)); // Purple
    MyMatrix.foreground(RGB(255,128,64)); // Warm white
    MyMatrix.printString("2015");

    MyMatrix.locatePixelX(39);
//    MyMatrix.foreground(RGB(0,255,64));
//    MyMatrix.foreground(RGB(0,64,255));
    MyMatrix.printString("22~C");

//        MyMatrix.printf("Graphic");


    MyMatrix.setWriteBuffer(1);
        Hsv.SetS(1);
        Hsv.SetV(1);
        for (int i = 0; i < 360; i++)
        {
            for (int r = 1; r <= 36; r++) {
                float Sat = (float)r /15.0;
                Hsv.SetS(Sat);
                Hsv.SetH((float)i/360.0);
                float R = Hsv.GetR() * 255;
                float G = Hsv.GetG() * 255;
                float B = Hsv.GetB() * 255;
                int x = sin(i * PI / 180) * r;
                int y = cos(i * PI / 180) * r;
                MyMatrix.drawPixel(x + 32, y + 16, RGB((uint8_t) R, (uint8_t) G, (uint8_t) B));
            }
        }
//    MyMatrix.setDisplayBuffer(1);
//    MyMatrix.setDisplayBuffer(1);
//        wait(1.0);


    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
//        led1 = !led1;
        if (button)
            MyMatrix.setDisplayBuffer(0);
        else
            MyMatrix.setDisplayBuffer(1);

        wait(0.1);
    }
}
