#ifndef PCA9745B_H
#define PCA9745B_H

/**
  * SPI speed used by the mbed to communicate with the PCA9745B
  * The PCA9745B supports up to 10Mhz.
  */
#define SPI_SPEED 1000000

/**
  *  Using the TLC5 class to control an LED:
  *  @code
  *  #include "mbed.h"
  *  #include "PCA9745B.h"
  *  
  *  // Create the TLC5711 instance
  *  PCA9745B tlc(1, p7, p5);
  *  
  *  int main()
  *  {   
  *      
  *      while(1)
  *      {
  *         // Led1 -> R0
  *         tlc.setLED(0, 65535, 0, 0);
  *         tlc.write( );
  *         tlc.setLED(1, 0, 0, 0);
  *         tlc.write( );
  *         tlc.setLED(2, 0, 0, 0);
  *         tlc.write( );
  *         tlc.setLED(3, 0, 0, 0);
  *         tlc.write( );
  *         wait( 1 );
  *  
  *      }
  *  }
  *  @endcode
  */

 class PCA9745B
{

public:/**
      *  Set up the PCA9745B
      *  @param SCLK - The SCK pin of the SPI bus
      *  @param MOSI - The MOSI pin of the SPI bus
      *  @param number - The number of PCA9745Bs 
      */
  
    PCA9745B(uint8_t number, PinName SCLK, PinName MOSI);

  void setPWM(uint8_t chan, uint16_t pwm);
  void setLED(uint8_t lednum, uint16_t r, uint16_t g, uint16_t b);
  void write(void);    
        
  uint8_t n;
  
  private:
  
  SPI spi;
  
  uint16_t *pwmbuffer;

  uint8_t BCr, BCg, BCb;
  int8_t numdrivers;

};
 
#endif
