#ifndef __NMEA0183_H__
#define __NMEA0183_H__

#include "mbed.h"
 
#define NMEA0183_BUF_SIZE 240

class NMEA0183 {
public:
    NMEA0183();
    int CheckParity(char *nmea0183_string);

private:
    void SubString(char *s, char *d, int pos, int len); //usage: SubString(Src, Dst, Pos, Len);

protected:
    char buf_[NMEA0183_BUF_SIZE];
    inline int hex2dec(char c) {
        if (c >= '0' && c <='9') return c - '0';
        if (c >= 'a' && c <= 'f') return c - 'a' + 10;
        if (c >= 'A' && c <= 'F') return c - 'A' + 10;
        return 0;
    };

};

#endif
