#include "NMEA0183.h"

NMEA0183::NMEA0183()
{
}

// CheckParity
// Returns 1 if valid
int NMEA0183::CheckParity(char *nmea0183_string)
{
    // Calculate parity
    char parity_calculated = 0x00;
    for (int i = 1; i < strlen(nmea0183_string)-3; i++) {
        parity_calculated ^= nmea0183_string[i];
    }

    // Print parity_calculated to string
//    char parity_calculated_str[3];
//    snprintf(parity_calculated_str, 3, "%02x", parity_calculated);

    uint8_t len = strlen(nmea0183_string);
    char parity_given = hex2dec(nmea0183_string[len-2]) * 16 +  hex2dec(nmea0183_string[len-1]);

    // Compare values
    if (parity_calculated == parity_given) {
        return 1;
    }     
    return 0;
}

void NMEA0183::SubString(char *s, char *d, int pos, int len) //usage: substring(Src, Dst, Pos, Len);
{
//usage: substring(Source, Destination, pos, len);
    char *t;
 
    s=s+pos;
    t=s+len;
    while (s!=t) {
        *d=*s;
        s++;
        d++;
    }
    *d='\0';
}

