#ifndef _NHD_0420DZW_OLED_H_
#define _NHD_0420DZW_OLED_H_

/**
* @file NHD_0420DZW_OLED.h
* @brief this header file will contain the definitions to interface the New Haven
* NHD-0420DZW-AY5 display using a 4-wire software spi bus bus.
* @author Jack Berkhout
*
* @date 2016-10-21
*/

/**
* Class for the New Haven NHD-0420DZW-AY5 SPI LCD 4x20
* @author Jack Berkhout
* @date 2016-10-21
*/

#include "mbed.h"
//#include "TextDisplay.h"

#define LCD_COMMAND 0
#define LCD_DATA    1
#define LCD_WRITE   0
#define LCD_READ    1

#define LCD_CLEAR_DISPLAY   0x01
#define LCD_RETURN_HOME     0x02
#define LCD_CURSOR_INCR     0x06
#define LCD_DISPLAY_OFF     0x08
#define LCD_DISPLAY_ON      0x0C
#define LCD_FUNCTION_SET    0x38
#define LCD_BUSSY_FLAG      0x80
#define LCD_NUMBER_OF_CHARACTERS 20
#define LCD_NUMBER_OF_LINES       4

#define LCD_LINE_1 0x80
#define LCD_LINE_2 0xC0
#define LCD_LINE_3 0x94
#define LCD_LINE_4 0xD4

#define LCD_CLOCK_PULSE_LENGTH 1
#define LCD_RS_BIT_MASK 0x0200
#define LCD_Rw_BIT_MASK 0x0100

/* set CGRAM addr */
#define LCD_CGRAM(n)        (0x40 + ((n) << 3))
// *.... 16
// **... 24
// ***.. 28
// ****. 30
// ***** 31
// *..*. 18
// *..*. 18
// .***. 14

//#define CHARACTERBYTES { \
//     0,  0,  0,  0,  0,  0,  0,  0, \
//    16, 16, 16, 16, 16, 16, 16, 16, \
//    24, 24, 24, 24, 24, 24, 24, 24, \
//    28, 28, 28, 28, 28, 28, 28, 28, \
//    30, 30, 30, 30, 30, 30, 30, 30, \
//    31, 31, 31, 31, 31, 31, 31, 31, \
//     1,  1,  1,  1,  1,  1,  1,  1 \
//}

#define CHARACTERBYTES { \
     0,  0,  0,  0,  0,  0,  0,  0, \
     0,  0,  0,  16,  16, 0, 0, 0, \
     0,  0,  0,  24,  24, 0, 0, 0, \
     0,  0,  0,  28,  28, 0, 0, 0, \
     0,  0,  0,  30,  30, 0, 0, 0, \
     0,  0,  0,  31,  31, 0, 0, 0, \
     0,  0,  0,  0,  0,  0,  0,  0, \
     0,  0,  0,  0,  0,  0,  0,  0 \
}

//class NHD_0420DZW_OLED {
class NHD_0420DZW_OLED : public Stream {
public:
    /**
    * @brief Create a new Class to interface to an NH-0216K3Z-NSW-BBW 2x16 Character LCD from New Haven
    **/
    NHD_0420DZW_OLED(PinName mosi, PinName miso, PinName sck, PinName cs, const char *name);

    void init(void);

    void cls(void);
    void cursorHome(void);
    
    void writeCharacter(int column, int row, int c);
    void writeCharacter(char character);
    void writeString(char *charString);
    void writeString(int y, char *charString);
    void writeString(int x, int y, char *charString);
    void clearLine(int y);
    void clearRegion(int x, int y, int length);
    void locate(int X, int Y);
    void drawBar(int X, int Y, int Value, int Max);

    virtual bool claim (FILE *stream);

private:
    DigitalOut _lcd_csb;
    DigitalOut _lcd_scl;
    DigitalOut _lcd_sdi;
    DigitalIn  _lcd_sdo;  

    void writeCommand(int data);
    void writeData(int data);
    int readAddress(void);
    void waitBusy(void);
    int readBusyFlag(void);
    void writeSerial(int rs, int rw, int data);
    int serialInstruction(int rs, int rw, int data1, int data2);
    int serialData(int rs, int rw, int data1, int data2);
    int clockSerial(int dataOut, int bits);
    void selectSerial(bool select);

// https://developer.mbed.org/users/4180_1/notebook/how-to-get-printf-to-work-in-a-new-display-driver-/
//and add this to the end of the class
protected:
    //used by printf - supply a new _putc virtual function for the new device
    virtual int _putc(int c) {
        writeData(c); //your new LCD put to print an ASCII character on LCD
        return 0;
    };
//assuming no reads from LCD
    virtual int _getc() {
        return -1;
    }

    // character location
    uint16_t _column;
    uint16_t _row;
    char *_path;

};
#endif