#include "I2CList.h"

I2CList::I2CList(PinName sda, PinName scl) : i2c(sda, scl)
{
}

char * I2CList::GetName(int address)
{
    strcpy(i2c_name, "");
    if (address == 0x30)
        strcpy(i2c_name, "MCP9808   Temp. Sensor");
    if (address == 0x46)
        strcpy(i2c_name, "BH1750FVI Light Sensor");
    if (address == 0x52)
        strcpy(i2c_name, "TSL2591   Light Sensor");
    if (address == 0x6F)
        strcpy(i2c_name, "MCP79412  RTC (Real Time Clock)");
    if (address == 0x70)
        strcpy(i2c_name, "FT6206    CTPC (Capacitive Touch Panel Controller)");
    if (address == 0x72)
        strcpy(i2c_name, "TSL2561   Light Sensor");
    if (address == 0x78)
        strcpy(i2c_name, "SD1306    OLED Display");
    if ((address == 0x80) || (address == 0xE0))
        strcpy(i2c_name, "PCA9685   LED PWM 16x12-bit");
    if ((address == 0x90) || (address == 0x92))
        strcpy(i2c_name, "ADS1115   ADC 4x16-bit");
    if (address == 0xA0)
        strcpy(i2c_name, "24C256    EEPROM 32kB");
    if (address == 0xAC)
        strcpy(i2c_name, "24C32     EEPROM 4kB");
    if (address == 0xD0)
        strcpy(i2c_name, "RTC       RTC (Real Time Clock)");
    if (address == 0xD2)
        strcpy(i2c_name, "AMG8833   8x8 Infrared Array Sensor");
    if (address == 0xE0)
        strcpy(i2c_name, "PCA9685   LED All Call");
        
    return i2c_name;
}

void I2CList::List(void)
{
    // 0x80, 0xE0 PCA9685
    printf("Searching for I2C devices...\n");
    printf("I2C    Addr   Device    Description\n");
    wait(0.001);
    printf("-----------------------------------------------------------\n");
    wait(0.001);
    // i2c1
    int i = 1;
    for (int address = 0; address < 256; address += 2) {
        if (!i2c.write(address, NULL, 0)) { // 0 returned is ok
            printf("1.%02d   0x%02X   %s\n", i, address, GetName(address));
            i++;
            wait(0.001);
        }
    }
    printf("\n");
}
