#include "FT5206.h"

FT5206::FT5206(PinName sda, PinName scl, PinName interrupt) : m_i2c(sda, scl), m_interrupt(interrupt) {
    m_addr = (FT5206_I2C_ADDRESS << 1);
    m_i2c.frequency(FT5206_I2C_FREQUENCY);

    // Interrupt
    m_interrupt.mode(PullUp);
    m_interrupt.enable_irq();
    m_interrupt.fall(this, &FT5206::intPanelTouched);

    init();
}

void FT5206::init(void) {
    panelTouched = false;

    if(DEBUG_OUTPUT_ENABLED) {
        printf("Trying to initialize FT5206 by I2C\r\n");
    }

    writeRegister8(FT5206_DEVICE_MODE, 0);

    for (int i = 0; i < 5; i++) {
        touchCoordinatesX[0] = -1;
        touchCoordinatesY[0] = -1;
    }

    if(DEBUG_OUTPUT_ENABLED) {
        printf("Setup done.\r\n");
    }
}

uint8_t FT5206::getTouchPositions(void) {
    numberOfTouchPoints = readRegister8(FT5206_TD_STATUS) & 0xF;

    for (int i = 0; i < 5; i++) {
        touchCoordinatesX[0] = -1;
        touchCoordinatesY[0] = -1;
    }
    if (numberOfTouchPoints > 0) {
        touchCoordinatesX[0] = (readRegister8(FT5206_TOUCH1_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH1_XL);
        touchCoordinatesY[0] = (readRegister8(FT5206_TOUCH1_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH1_YL);
    }
    if (numberOfTouchPoints > 1) {
        touchCoordinatesX[1] = (readRegister8(FT5206_TOUCH2_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH2_XL);
        touchCoordinatesY[1] = (readRegister8(FT5206_TOUCH2_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH2_YL);
    }
    if (numberOfTouchPoints > 2) {
        touchCoordinatesX[2] = (readRegister8(FT5206_TOUCH3_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH3_XL);
        touchCoordinatesY[2] = (readRegister8(FT5206_TOUCH3_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH3_YL);
    }
    if (numberOfTouchPoints > 3) {
        touchCoordinatesX[3] = (readRegister8(FT5206_TOUCH4_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH4_XL);
        touchCoordinatesY[3] = (readRegister8(FT5206_TOUCH4_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH4_YL);
    }
    if (numberOfTouchPoints > 4) {
        touchCoordinatesX[4] = (readRegister8(FT5206_TOUCH5_XH) & 0x0f)*256 + readRegister8(FT5206_TOUCH5_XL);
        touchCoordinatesY[4] = (readRegister8(FT5206_TOUCH5_YH) & 0x0f)*256 + readRegister8(FT5206_TOUCH5_YL);
    }
    return numberOfTouchPoints;
}


// Interrupt for touch detection
void FT5206::intPanelTouched(void) {
    getTouchPositions();
    panelTouched = true;
}

bool FT5206::getPanelTouched(void) {
    if (panelTouched == true) {
        panelTouched = false;
        return true;
    } else {
        return false;
    }
}

char FT5206::readRegister8(char reg) {
    char val;
    m_i2c.write(m_addr, &reg, 1);
    m_i2c.read(m_addr, &val, 1);
    return val;
}

void FT5206::writeRegister8(char reg, char val) {
    char data[2];
    data[0] = reg;
    data[1] = val;
    m_i2c.write((int)FT5206_I2C_ADDRESS, data, 2);
}
