/* FRAMSPI - Ramtron FRAM FM24VXX series driver
* Copyright (c) 2012 Oleg Evsegneev
* Released under the MIT License: http://mbed.org/license/mit
*
* Datasheet http://www.ramtron.com/files/datasheets/FM25V02_ds.pdf
*/
 
#include "mbed.h"
#include "FRAMSPI.h"
 
FRAMSPI::FRAMSPI(SPI& spi, PinName ncs) : _spi(spi), _ncs(ncs) {
    deselect();
}
 
void FRAMSPI::select() {
    _ncs = 0;
}
 
void FRAMSPI::deselect() {
    _ncs = 1;
}
 
void FRAMSPI::readID( char *buff ) {
    select();
    _spi.write(READ_SN);
    for( int i=0; i<8; i++ )
        buff[i] = (char) _spi.write(0);
    deselect();
}
 
void FRAMSPI::readSN( char *buff ) {
    select();
    _spi.write(READ_SN);
    for( int i=0; i<2; i++ )
        buff[i] = (char) _spi.write(0);
    deselect();
}
 
void FRAMSPI::prepareCommand(char cmd, int addr) {
    if( cmd == WRITE ){
        select();
        _spi.write(WRITE_ENABLED);
        deselect();
    }
    select();
    _spi.write(cmd);
    _spi.write(addr >> 8);
    _spi.write(addr & 0xFF);
}
 
// write
void FRAMSPI::write(int addr, char byte) {
    prepareCommand(WRITE, addr);
    _spi.write(byte);
    deselect();
}
 
void FRAMSPI::write(int addr, char *buff, int cnt) {
    prepareCommand(WRITE, addr);
    for (int i = 0; i < cnt; i++) {
        _spi.write(buff[i]);
    }
    deselect();
}
 
// read
char FRAMSPI::read(int addr) {
    char res;
    prepareCommand(READ, addr);
    res = _spi.write(0);
    deselect();
    return res;
}
 
void FRAMSPI::read(int addr, char * buff, int cnt) {
    prepareCommand(READ, addr);
    for (int i = 0; i < cnt; i++) {
        buff[i] = _spi.write(0);
    }
    deselect();
}
