#include "mbed.h"
#include "cc3000.h"
#include "main.h"
#include "NTPClient.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

#define CC3000_IRQ   D3  // (D3)
#define CC3000_EN    D5  // (D5)
#define CC3000_CS    D10 // (D10)
#define CC3000_MOSI  D11 // (D11)
#define CC3000_MISO  D12 // (D12)
#define CC3000_SCLK  D13 // (D13)

#define SSID         "Prakjaroen"
#define PHRASE       "A4B5C6D7E8F9"
#define SECURITY     WPA2

#define IP           "192.168.2.165"
#define MASK         "255.255.255.0"
#define GW           "192.168.2.1"

#define DHCP         1

#if (DHCP == 1)
    #define STATIC_IP    0
    #define IP_INIT      DHCP
#else
    #define STATIC_IP    1
    #define IP_INIT      STATIC_IP
#endif

using namespace mbed_cc3000;

#define MY_BOARD MBED_BOARD_EXAMPLE

/* cc3000 module declaration specific for user's board. Check also init() */
#if (MY_BOARD == WIGO)
cc3000 wifi(PTA16, PTA13, PTD0, SPI(PTD2, PTD3, PTC5), SSID, PHRASE, SECURITY, false);
Serial pc(USBTX, USBRX);
#elif (MY_BOARD == WIFI_DIPCORTEX)
cc3000 wifi(p28, p27, p30, SPI(p21, p14, p37), SSID, PHRASE, SECURITY, false);
Serial pc(UART_TX, UART_RX);
#elif (MY_BOARD == MBED_BOARD_EXAMPLE)
cc3000 wifi(CC3000_IRQ, CC3000_EN, CC3000_CS, SPI(CC3000_MOSI, CC3000_MISO, CC3000_SCLK), SSID, PHRASE, SECURITY, false); //SparkFun Board on Arduino pin definitions
//Serial pc(USBTX, USBRX);
//    Serial pc(P4_28, P4_29);

    #if defined(TARGET_NUCLEO_F411RE)
    Serial pc(USBTX, USBRX);
    #elif defined(TARGET_NUCLEO_F446RE)
    Serial pc(USBTX, USBRX);
    #elif defined(TARGET_ARCH_PRO)
    Serial pc(P4_28, P4_29);
    #elif defined(TARGET_ARCH_MAX)
    Serial pc(USBTX, USBRX);
    Serial bt(D6, D7);  // tx, rx, Arch Max
    #elif defined(TARGET_LPC4337)
    Serial pc(P2_10, P2_11); // TX, RX
    #elif defined(TARGET_DISCO_F746NG)
    Serial pc(USBTX, USBRX);
    #else
    Serial pc(USBTX, USBRX);
    #endif



#else

#endif

// array to store RM parameters from EEPROM
unsigned char cRMParamsFromEeprom[128];

// array to store MAC address from EEPROM
unsigned char cMacFromEeprom[6];

LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

int main()
{
    uint8_t firmware_ver[2];
    signed char mac_status = -1;
    unsigned char FW_status = 1;

    init(); // board dependent init
    pc.baud(230400);
    printf("\r\n--------------------------------------------------------------------------------\r\n");

    printf("Target   : ");
#if defined(TARGET_NUCLEO_F411RE)
    printf("NUCLEO F411RE\r\n");
#elif defined(TARGET_NUCLEO_F446RE)
    printf("NUCLEO F446RE\r\n");
#elif defined(TARGET_ARCH_PRO)
    printf("Seeed Arch PRO\r\n");
#elif defined(TARGET_ARCH_MAX)
    printf("Seeed Arch Max\r\n");
#elif defined(TARGET_LPC4337)
    printf("LPC4337\r\n");
#elif defined(TARGET_DISCO_F746NG)
    printf("DISCO_F746NG\r\n");
#else
    printf("Unknown\r\n");
#endif

    printf("CPU Clock: %3.3f MHz\r\n", ((float)SystemCoreClock/1000000.0));

    printf("MAC      : ");
    char mac_board[6];
    mbed_mac_address(mac_board);
    for(int i=0; i<6;i++) {
        printf("%02X", mac_board[i]);
        if (i < 5) printf(":");
    }
    printf("\r\n");


    printf("mbed cc3000 NTP client demo.\r\n");

#if (DHCP == 1)
    printf("Initialize the interface using DHCP...\r\n");
    printf("wifi.init() ");
    wifi.init();
#else
    printf("Initialize the interface using a static IP address...\r\n");
    printf("wifi.init(%s, %s, %s) ", IP, MASK, GW);
    wifi.init(IP, MASK, GW);
#endif
    printf("done.\r\n");

    printf("Read from cc3000...\r\n");
        
    // Read Firmware Version and MAC Address
    FW_status = wifi.read_sp_version(firmware_ver);   // read actual Firmware version
    if(FW_status == 0){
        printf("Firmware version: %d.%d\r\n", firmware_ver[0], firmware_ver[1]);
        mac_status = wifi.get_mac_address(cMacFromEeprom);
        if(mac_status == 0){
            printf("MAC address     : ");
            for(int i = 0; i < 6; i++) {
                printf("%02X", cMacFromEeprom[i]);
                if (i < 5) printf(":");
            }
            printf("\r\n");
        }
    } else {
        printf("ERROR: CC3000 not found - check connections !\r\n");
    }

    // WiFi parameters
    printf("WiFi parameters:\r\n");
    printf("SSID            : %s\r\n", SSID);
    printf("Phrase          : %s\r\n", PHRASE);
    printf("Security        : ");
    if (SECURITY == 0) printf("NONE");
    if (SECURITY == 1) printf("WEP");
    if (SECURITY == 2) printf("WPA");
    if (SECURITY == 3) printf("WPA2");
    printf("\r\n");
    
    wait(1.0);
  
    // Connect to WiFi
    printf("Bring the interface up...\r\n");
    if (wifi.connect() == -1) {
        printf("ERROR: Failed to connect. Please verify connection details and try again.\r\n");
    }
    char *ip     = wifi.getIPAddress();
    char *mask   = wifi.getNetworkMask();
    char *gate   = wifi.getGateway();
    char *mac    = wifi.getMACAddress();
    bool conn    = wifi.is_connected();
    bool dhcp    = wifi.is_dhcp_configured();
    bool enabled = wifi.is_enabled();
    
    printf("IP              : %s\r\n", ip);
    printf("Netmask         : %s\r\n", mask);
    printf("Gateway         : %s\r\n", gate);
    printf("MAC             : %s\r\n", mac);
    printf("Connected       : %d\r\n", conn);
    printf("DHCP            : %d\r\n", dhcp);
    printf("Enabled         : %d\r\n", enabled);

    wait(1.0);
    
    
    // Read time from server
    NTPClient ntp_client;
    // NTP Server Parameters
//    char* domain_name = "217.114.59.3";
    char* domain_name = "2.nl.pool.ntp.org";
//    char* domain_name = "0.uk.pool.ntp.org";
    int   port_number = 123;
    time_t ct_time;
    char time_buffer[80];    
    char time_buffer_old[80];    

    printf("Reading time: ");
    if (ntp_client.setTime(domain_name, port_number) == 0) {
        printf("Passed.\r\n");
        ct_time = time(NULL) + 7200; // Summer time - Convert to Europe/Amsterdam Time
        set_time(ct_time);
        strftime(time_buffer, 80, "%a %d-%b-%Y %T", localtime(&ct_time));
        printf("Time            : %s\r\n", time_buffer);
    } else {
        printf("FAILED!\r\n");
    }

    strcpy(time_buffer_old, "Dummy value");


    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t text[30];
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;

    lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN DEMO", CENTER_MODE);
    wait(1);

    status = ts.Init(lcd.GetXSize(), lcd.GetYSize());
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else {
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }

    wait(1);
    lcd.SetFont(&Font12);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);

    while(1) {

        ct_time = time(NULL);
//        strftime(time_buffer, 80, "%S", localtime(&ct_time));
        strftime(time_buffer, 80, "%a %d-%b-%Y %T", localtime(&ct_time));
        if (strcmp(time_buffer, time_buffer_old) != 0) {
            strcpy(time_buffer_old, time_buffer);
            printf("%s\r\n", time_buffer);
    lcd.DisplayStringAt(0, LINE(15), (uint8_t *)time_buffer, CENTER_MODE);
            strftime(time_buffer, 80, "%T", localtime(&ct_time));
            // 21:00:00
            if ((time_buffer[3] == '0') && (time_buffer[4] == '0') && 
                (time_buffer[6] == '0') && (time_buffer[7] == '0')) {
                // Sync once per hour
                printf("Reading time: ");
                if (ntp_client.setTime(domain_name, port_number) == 0) {
                    printf("Passed.\r\n");
                    ct_time = time(NULL) + 7200; // Summer time - Convert to Europe/Amsterdam Time
                    set_time(ct_time);
                    strftime(time_buffer, 80, "%a %d-%b-%Y %T", localtime(&ct_time));
//                    printf("Time            : %s\r\n", time_buffer);
    lcd.DisplayStringAt(0, LINE(15), (uint8_t *)time_buffer, CENTER_MODE);
                } else {
                    printf("FAILED!\r\n");
                }
            }
        }

        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 5; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;

            cleared = 0;

            sprintf((char*)text, "Touches: %d", TS_State.touchDetected);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);

            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                sprintf((char*)text, "Touch %d: x=%d y=%d    ", idx+1, x, y);
                lcd.DisplayStringAt(0, LINE(idx+1), (uint8_t *)&text, LEFT_MODE);
            }

            lcd.DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);
        } else {
            if (!cleared) {
                lcd.Clear(LCD_COLOR_BLUE);
                sprintf((char*)text, "Touches: 0");
                lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE);
                cleared = 1;
            }
        }
    }
}
