#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "FT6206.h"

#include "Arial12x12.h"

#define PIN_XP          A3
#define PIN_XM          A1
#define PIN_YP          A2
#define PIN_YM          A0
#define PIN_SCLK        D13
#define PIN_MISO        D12
#define PIN_MOSI        D11
#define PIN_CS_TFT      D10  // chip select pin
#define PIN_DC_TFT      D9   // data/command select pin.
#define PIN_RESET_TFT   D8
//#define PIN_BL_TFT      D7
#define PIN_CS_SD       D4

#define PORTRAIT        0
#define LANDSCAPE       1

#define PIN_SCL_FT6206  P0_28
#define PIN_SDA_FT6206  P0_27
#define PIN_INT_FT6206  D7

#define ILI9341_TFTWIDTH  320
#define ILI9341_TFTHEIGHT 240

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//SPI_TFT_ILI9341 TFT(p5, p6, p7, p8, p9, p10,"TFT"); // mosi, miso, sclk, cs, reset, dc
SPI_TFT_ILI9341 TFT(PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_RESET_TFT, PIN_DC_TFT, "TFT"); // mosi, miso, sclk, cs, reset, dc 
FT6206 FT6206(PIN_SDA_FT6206, PIN_SCL_FT6206, PIN_INT_FT6206); // sda, scl, int

int main()
{
    //Configure the display driver
    TFT.claim(stdout);
    TFT.background(Black);
    TFT.foreground(White);
    TFT.set_orientation(LANDSCAPE);
    TFT.cls();

    //Print a welcome message
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.locate(0,0);
    TFT.printf("Hello mbed!\n");

    FT6206.begin();
    int X1, Y1, X2, Y2;
    X2 = -100;
    while(1) {
//        if (FT6206.touched()) {
        if (FT6206.dataReceived()) {
//            led1 = !led1;
            // Retrieve a point  
            TS_Point p = FT6206.getPoint();
            X1 = X2;
            Y1 = Y2;
            X2 = p.x;
            Y2 = p.y;
//            printf("Touch %3d %3d\n", p.x, p.y);
            if ((X1 > 0) && (Y1 > 0) && (X2 > 0) && (Y2 > 0)) {
                TFT.line(X1, Y1, X2, Y2, Yellow);
            }
        }


//        TFT.printf("Jacksoft\n");
//        wait(0.05);
    }
}


/*
#include "mbed.h"

PwmOut mypwm(PWM_OUT);

DigitalOut myled(LED1);

int main() {
    
    mypwm.period_ms(10);
    mypwm.pulsewidth_ms(1);
  
    printf("pwm set to %.2f %%\n", mypwm.read() * 100);
    
    while(1) {
        myled = !myled;
        wait(1);
    }
}
*/
