#ifndef __AP3000_H__
#define __AP3000_H__

#include "mbed.h"
#include "main.h"

#define TAGVAL_NONE 0xffff

#define BUTTON_ACCEPT_ALARM_TAG 1
#define BUTTON_ACCEPT_HORN_TAG 2
#define BUTTON_SET_TAG 3
#define BUTTON_DIM_TAG 4

#define BUTTON_RELEASED 0
#define BUTTON_PRESSED 1

#define BIGHTNESS_SELECT_LOW  0
#define BIGHTNESS_SELECT_HIGH 1

#define INDICATOR_OFF 0
#define INDICATOR_ON  1

//#define INDICATOR_RUN_STATUS_OFF 0
//#define INDICATOR_RUN_STATUS_RUNNING 1
//#define INDICATOR_RUN_STATUS_WARNING 2
//#define INDICATOR_RUN_STATUS_OFF_RED 3
//#define INDICATOR_RUN_STATUS_DISABLED 4
//
//#define INDICATOR_ALARM_STATUS_OFF 0
//#define INDICATOR_ALARM_STATUS_WARNING 1
//#define INDICATOR_ALARM_STATUS_FAILURE 2

enum System {
    MAIN_SYSTEM = 0,
    AUX_SYSTEM,
    GLOBAL_SYSTEM
};

enum Alarm {
    PHASE_FAIL = 0,
    MAIN_POWER,
    CTRL_POWER,
    OIL_PRESS,
    HYDR_LOCK,
    OVERLOAD,
    OIL_LEVEL,
    OIL_FILTER,
    OIL_TEMP,
    FU_FAILURE
};

enum IndicatorRunStatus {
    RUN_STATUS_OFF = 0,
    RUN_STATUS_RUNNING,
    RUN_STATUS_WARNING,
    RUN_STATUS_DISABLED,
    RUN_STATUS_OFF_RED,
    RUN_STATUS_BLANK
};

enum IndicatorAlarmStatus {
    ALARM_STATUS_OFF = 0,
    ALARM_STATUS_WARNING,
    ALARM_STATUS_FAILURE
};

enum Pump {
    PUMP_OFF = 0,
    PUMP_IN_USE,
    PUMP_IN_USE_MAIN,
    PUMP_IN_USE_AUX
};

enum IndicatorLightStatus {
    STEADY_OFF = 0,
    BLINK_WARNING_ON,
    STEADY_WARNING_ON,
    BLINK_FAILURE_ON,
    STEADY_FAILURE_ON,
    BLINK_RUNNING_ON,
    STEADY_RUNNING_ON,
    BLINK_DISABLED_ON,
    STEADY_DISABLED_ON,
    BLINK_OFF_RED_ON,
    STEADY_OFF_RED_ON
};

typedef struct Button {
    uint8_t accept_alarm_pressed;
    uint8_t accept_horn_pressed;
    uint8_t set_pressed;
    uint8_t dim_pressed;
} button;

typedef struct Indicator {
    enum IndicatorRunStatus   md_main_running;
    enum IndicatorLightStatus md_main_running_light;
    enum IndicatorAlarmStatus rb_main_phase_fail;
    enum IndicatorLightStatus rb_main_phase_fail_light;
    enum IndicatorAlarmStatus rb_main_main_power;
    enum IndicatorLightStatus rb_main_main_power_light;
    enum IndicatorAlarmStatus rb_main_ctrl_power;
    enum IndicatorLightStatus rb_main_ctrl_power_light;
    enum IndicatorAlarmStatus rb_main_oil_press;
    enum IndicatorLightStatus rb_main_oil_press_light;
    enum IndicatorAlarmStatus rb_main_hydr_lock;
    enum IndicatorLightStatus rb_main_hydr_lock_light;
    enum IndicatorAlarmStatus rb_main_overload;
    enum IndicatorLightStatus rb_main_overload_light;
    enum IndicatorAlarmStatus rb_main_oil_level;
    enum IndicatorLightStatus rb_main_oil_level_light;
    enum IndicatorAlarmStatus rb_main_oil_filter;
    enum IndicatorLightStatus rb_main_oil_filter_light;
    enum IndicatorAlarmStatus rb_main_oil_temp;
    enum IndicatorLightStatus rb_main_oil_temp_light;
    
    enum IndicatorRunStatus   md_aux_running;
    enum IndicatorLightStatus md_aux_running_light;
    enum IndicatorAlarmStatus rb_aux_phase_fail;
    enum IndicatorLightStatus rb_aux_phase_fail_light;
    enum IndicatorAlarmStatus rb_aux_main_power;
    enum IndicatorLightStatus rb_aux_main_power_light;
    enum IndicatorAlarmStatus rb_aux_ctrl_power;
    enum IndicatorLightStatus rb_aux_ctrl_power_light;
    enum IndicatorAlarmStatus rb_aux_oil_press;
    enum IndicatorLightStatus rb_aux_oil_press_light;
    enum IndicatorAlarmStatus rb_aux_hydr_lock;
    enum IndicatorLightStatus rb_aux_hydr_lock_light;
    enum IndicatorAlarmStatus rb_aux_overload;
    enum IndicatorLightStatus rb_aux_overload_light;
    enum IndicatorAlarmStatus rb_aux_oil_level;
    enum IndicatorLightStatus rb_aux_oil_level_light;
    enum IndicatorAlarmStatus rb_aux_oil_filter;
    enum IndicatorLightStatus rb_aux_oil_filter_light;
    enum IndicatorAlarmStatus rb_aux_oil_temp;
    enum IndicatorLightStatus rb_aux_oil_temp_light;
    
    enum IndicatorAlarmStatus rb_fu_failure;
    enum IndicatorLightStatus rb_fu_failure_light;
    enum Pump                 pump_in_use;
    enum IndicatorLightStatus pump_in_use_light;
} indicator;

void InitAP3000(void);
void RegularButton(int16_t x0, int16_t y0, int16_t w, int16_t h, int16_t corner, uint8_t style, uint8_t R, uint8_t G, uint8_t B, uint8_t text_color, char *text);
void RoundedRectangle(int16_t x0, int16_t y0, int16_t w, int16_t h, int16_t corner, uint8_t style, uint8_t Ro, uint8_t Go, uint8_t Bo, uint8_t Ri, uint8_t Gi, uint8_t Bi, uint8_t text_color, char *text);

void updateAlarmLights(void);

void processButtonPressed(uint16_t tagval);
void processButtonReleased(void);
void backupAlarms(void);
void restoreAlarms(void);

uint8_t getDisplayBrighnessSelect(void);
void setDisplayBrighnessSelect(uint8_t select);
void toggleDisplayBrighnessSelect(void);
void setDisplayBrighnessHigh(uint8_t value);
void setDisplayBrighnessLow(uint8_t value);

uint8_t getButtonAcceptAlarm(void);
void setButtonAcceptAlarm(uint8_t status);
uint8_t getButtonAcceptHorn(void);
void setButtonAcceptHorn(uint8_t status);
uint8_t getButtonSet(void);
void setButtonSet(uint8_t status);
uint8_t getButtonDim(void);
void setButtonDim(uint8_t status);

Pump getPumpInUse(void);
void setPumpInUse(Pump status);
IndicatorLightStatus getPumpInUseBlinkStatus(void);
void setPumpInUseBlinkStatus(IndicatorLightStatus status);

IndicatorLightStatus getPumpRunningBlinkStatus(System system);
void setPumpRunningBlinkStatus(System system, IndicatorLightStatus status);
IndicatorRunStatus getPumpRunningStatus(System system);
void setPumpRunningStatus(System system, IndicatorRunStatus status);
void togglePumpRunningStatus(System system, IndicatorRunStatus status);

IndicatorLightStatus getAlarmBlinkStatus(System system, Alarm alarm);
void setAlarmBlinkStatus(System system, Alarm alarm, IndicatorLightStatus status);
IndicatorAlarmStatus getAlarmStatus(System system, Alarm alarm);
void setAlarmStatus(System system, Alarm alarm, IndicatorAlarmStatus status);
void toggleAlarmStatus(System system, Alarm alarm, IndicatorAlarmStatus status);

bool checkIndicatorsChanged(void);

void loadSplashScreen(void);
void loadBitmaps(void);
void showSplashScreen(void);
void showMainPage(void);

void testIndicators(void);

#endif
