#include "mbed.h"
#include "AP3000.h"
#include "FT_Platform.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
//#include "HeapBlockDevice.h"
#include "SPIFBlockDevice.h"
#include "I2CEEBlockDevice.h"
//#include "FRAMSPI.h"
#include "BurstSPI.h"
#include "NMEA0183.h"
#include "nmea_parser.h"


Button main_button;
Indicator main_indicator;
Indicator main_indicator_previous;  // Track changes
Indicator main_indicator_backup;

//Timer touchTimer;
Timer blinker;
//Ticker blinkLights;

uint8_t brightnessLow;
uint8_t brightnessHigh;
uint8_t brightnessSelect;

uint8_t mainBlink;

void InitAP3000(void)
{
//    blinkLights.attach(&updateAlarmLights, 0.5);
    
    blinker.reset();
    blinker.start();
    mainBlink = false;
    
    setDisplayBrighnessLow(40);
    setDisplayBrighnessHigh(255);
    setDisplayBrighnessSelect(BIGHTNESS_SELECT_HIGH);
    
    main_button.accept_alarm_pressed        = BUTTON_RELEASED;
    main_button.accept_horn_pressed         = BUTTON_RELEASED;
    main_button.set_pressed                 = BUTTON_RELEASED;
    main_button.dim_pressed                 = BUTTON_RELEASED;

    setPumpInUse(PUMP_OFF);
    setPumpInUseBlinkStatus(STEADY_OFF);

//    main_indicator.pump_in_use              = PUMP_IN_USE_MAIN;
//    main_indicator.pump_in_use_light        = STEADY_OFF;
    
    // All Main and Aux alarms
    for(int system = MAIN_SYSTEM; system <= GLOBAL_SYSTEM; system++) {
        // MAIN_SYSTEM, AUX_SYSTEM, GLOBAL_SYSTEM
        for(int alarm = PHASE_FAIL; alarm <= FU_FAILURE; alarm++) {
            // PHASE_FAIL, MAIN_POWER, CTRL_POWER, OIL_PRESS, HYDR_LOCK,
            // OVERLOAD, OIL_LEVEL, OIL_FILTER, OIL_TEMP, FU_FAILURE
            setAlarmStatus((System)system, (Alarm)alarm, ALARM_STATUS_OFF);
            setAlarmBlinkStatus((System)system, (Alarm)alarm, STEADY_OFF);
        }
        if (system != GLOBAL_SYSTEM) {
            setPumpRunningStatus((System)system, RUN_STATUS_OFF);
            setPumpRunningBlinkStatus((System)system, STEADY_OFF);
        }
    }

//    main_indicator.md_main_running          = RUN_STATUS_OFF;
//    main_indicator.md_main_running_light    = STEADY_OFF;
//    main_indicator.md_aux_running           = RUN_STATUS_OFF;
//    main_indicator.md_aux_running_light     = STEADY_OFF;

//    main_indicator.rb_main_phase_fail       = ALARM_STATUS_OFF;
//    main_indicator.rb_main_phase_fail_light = STEADY_OFF;
//    main_indicator.rb_main_main_power       = ALARM_STATUS_OFF;
//    main_indicator.rb_main_main_power_light = STEADY_OFF;
//    main_indicator.rb_main_ctrl_power       = ALARM_STATUS_OFF;
//    main_indicator.rb_main_ctrl_power_light = STEADY_OFF;
//    main_indicator.rb_main_oil_press        = ALARM_STATUS_OFF;
//    main_indicator.rb_main_oil_press_light  = STEADY_OFF;
//    main_indicator.rb_main_hydr_lock        = ALARM_STATUS_OFF;
//    main_indicator.rb_main_hydr_lock_light  = STEADY_OFF;
//    main_indicator.rb_main_overload         = ALARM_STATUS_OFF;
//    main_indicator.rb_main_overload_light   = STEADY_OFF;
//    main_indicator.rb_main_oil_level        = ALARM_STATUS_OFF;
//    main_indicator.rb_main_oil_level_light  = STEADY_OFF;
//    main_indicator.rb_main_oil_filter       = ALARM_STATUS_OFF;
//    main_indicator.rb_main_oil_filter_light = STEADY_OFF;
//    main_indicator.rb_main_oil_temp         = ALARM_STATUS_OFF;
//    main_indicator.rb_main_oil_temp_light   = STEADY_OFF;
//
//    main_indicator.rb_aux_phase_fail        = ALARM_STATUS_OFF;
//    main_indicator.rb_aux_phase_fail_light  = STEADY_OFF;
//    main_indicator.rb_aux_main_power        = ALARM_STATUS_OFF;
//    main_indicator.rb_aux_main_power_light  = STEADY_OFF;
//    main_indicator.rb_aux_ctrl_power        = ALARM_STATUS_OFF;
//    main_indicator.rb_aux_ctrl_power_light  = STEADY_OFF;
//    main_indicator.rb_aux_oil_press         = ALARM_STATUS_OFF;
//    main_indicator.rb_aux_oil_press_light   = STEADY_OFF;
//    main_indicator.rb_aux_hydr_lock         = ALARM_STATUS_OFF;
//    main_indicator.rb_aux_hydr_lock_light   = STEADY_OFF;
//    main_indicator.rb_aux_overload          = ALARM_STATUS_OFF;
//    main_indicator.rb_aux_overload_light    = STEADY_OFF;
//    main_indicator.rb_aux_oil_level         = ALARM_STATUS_OFF;
//    main_indicator.rb_aux_oil_level_light   = STEADY_OFF;
//    main_indicator.rb_aux_oil_filter        = ALARM_STATUS_OFF;
//    main_indicator.rb_aux_oil_filter_light  = STEADY_OFF;
//    main_indicator.rb_aux_oil_temp          = ALARM_STATUS_OFF;
//    main_indicator.rb_aux_oil_temp_light    = STEADY_OFF;
//
//    main_indicator.rb_fu_failure            = ALARM_STATUS_OFF;
//    main_indicator.rb_fu_failure_light      = STEADY_OFF;
    
    main_indicator_previous = main_indicator;   // Copy to previous state
}

void loadBitmaps(void)
{
    TFT.ResetInflateFileBitmap();

//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_C_20x20_BL.bin", L8, 20, 20);
//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_C_20x20_BR.bin", L8, 20, 20);
//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_C_20x20_TL.bin", L8, 20, 20);
//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_C_20x20_TR.bin", L8, 20, 20);
//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_H_5x4.bin", L8, 5, 4);
//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_H_10x4.bin", L8, 10, 4);
//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_H_25x4.bin", L8, 25, 4);
//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_H_190x4.bin", L8, 190, 4);
//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_V_4x535.bin", L8, 4, 535);
//    TFT.LoadInflateFileBitmap("/fs/BACKGROUND_01_V_4x21.bin", L8, 4, 21);

//    TFT.LoadInflateFileBitmap("/fs/RegularButtonBlk_220x51r4t.bin", ARGB4, 220, 51);
//    TFT.LoadInflateFileBitmap("/fs/RegularButtonGray_220x51r10t.bin", ARGB4, 220, 51);
//    TFT.LoadInflateFileBitmap("/fs/RegularButtonRed_220x51r10t.bin", ARGB4, 220, 51);
//    TFT.LoadInflateFileBitmap("/fs/RegularButtonYel_220x51r10t.bin", ARGB4, 220, 51);
//    TFT.LoadInflateFileBitmap("/fs/RegularButtonGray_220x51r0t.bin", ARGB4, 220, 51);
//    TFT.LoadInflateFileBitmap("/fs/RegularButtonRed_220x51r0t.bin", ARGB4, 220, 51);
//    TFT.LoadInflateFileBitmap("/fs/RegularButtonYel_220x51r0t.bin", ARGB4, 220, 51);
//    TFT.LoadInflateFileBitmap("/fs/RegularButtonGray_220x51r0r10t.bin", ARGB4, 220, 51); // 40 characters
//    TFT.LoadInflateFileBitmap("/fs/RegularButtonRed_220x51r0r10t.bin", ARGB4, 220, 51);
//    TFT.LoadInflateFileBitmap("/fs/RegularButtonYel_220x51r0r10t.bin", ARGB4, 220, 51);

    TFT.LoadInflateFileBitmap("/fs/SwitchOn_234x132_blk.bin", L8, 234, 132);
    TFT.LoadInflateFileBitmap("/fs/SwitchOff_234x132_blk.bin", L8, 234, 132);
    TFT.LoadInflateFileBitmap("/fs/SwitchOn_100x132_blk.bin", L8, 100, 132);
    TFT.LoadInflateFileBitmap("/fs/SwitchOff_100x132_blk.bin", L8, 100, 132);
    TFT.LoadInflateFileBitmap("/fs/SwitchOn_115x66_t.bin", L8, 115, 66);
    TFT.LoadInflateFileBitmap("/fs/SwitchOff_115x66_t.bin", L8, 115, 66);

    TFT.LoadInflateFileBitmap("/fs/settings_40x40.bin", L8, 40, 40);
    TFT.LoadInflateFileBitmap("/fs/light-bulb_40x40.bin", L8, 40, 40);


    // Markus Adobe Ilustrator
//    TFT.LoadInflateFileBitmap("/fs/MD_DISABLED_230x70.bin", ARGB4, 230, 70);
//    TFT.LoadInflateFileBitmap("/fs/MD_OFF_230x70.bin", ARGB4, 230, 70);
//    TFT.LoadInflateFileBitmap("/fs/MD_OFF_GREY_230x70.bin", ARGB4, 230, 70);
//    TFT.LoadInflateFileBitmap("/fs/MD_RUNNING_230x70.bin", ARGB4, 230, 70);
//    TFT.LoadInflateFileBitmap("/fs/MD_WARNING_230x70.bin", ARGB4, 230, 70);
    
    // SVG generated bitmaps, FT813 Font: Google Yantramanav
    // https://www.w3schools.com/howto/tryit.asp?font=Yantramanav
    // https://fonts.google.com/?query=Yantramanav
    TFT.LoadInflateFileBitmap("/fs/MD_DISABLED_220x51bt.bin", ARGB4, 220, 51);
    TFT.LoadInflateFileBitmap("/fs/MD_OFF_Grey_220x51bt.bin", ARGB4, 220, 51);
    TFT.LoadInflateFileBitmap("/fs/MD_OFF_Red_220x51bt.bin", ARGB4, 220, 51);
    TFT.LoadInflateFileBitmap("/fs/MD_RUNNING_220x51bt.bin", ARGB4, 220, 51);
    TFT.LoadInflateFileBitmap("/fs/MD_WARNING_220x51bt.bin", ARGB4, 220, 51);

    TFT.LoadInflateFileBitmap("/fs/RUN_TIME_C_ON_21_X_21.bin", ARGB4, 21, 21);
    TFT.LoadInflateFileBitmap("/fs/RUN_TIME_C_OFF_21_X_21.bin", ARGB4, 21, 21);
    TFT.LoadInflateFileBitmap("/fs/RUN_TIME_L_ON_21_X_21.bin", ARGB4, 21, 21);
    TFT.LoadInflateFileBitmap("/fs/RUN_TIME_L_OFF_21_X_21.bin", ARGB4, 21, 21);
    TFT.LoadInflateFileBitmap("/fs/RUN_TIME_R_ON_21_X_21.bin", ARGB4, 21, 21);
    TFT.LoadInflateFileBitmap("/fs/RUN_TIME_R_OFF_21_X_21.bin", ARGB4, 21, 21);

//    TFT.DL(DISPLAY());                          // Display the image
    TFT.Swap();                                 // Swap the current display list
    TFT.Flush_Co_Buffer();                      // Download the command list into fifo
    TFT.WaitCmdfifo_empty();                    // Wait till coprocessor completes the operation
}

void loadSplashScreen(void)
{
    TFT.DLstart();                              // start a new display command list
    TFT.DL(CLEAR_COLOR_RGB(0x00, 0x00, 0x00));  // set the clear color to white
    TFT.DL(CLEAR(1, 1, 1));                     // clear buffers -> color buffer,stencil buffer, tag buffer
    TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));  // set the clear color to white
    TFT.DL(DISPLAY());                          // Display the image
    TFT.Swap();                                 // Swap the current display list
    TFT.Flush_Co_Buffer();                      // Download the command list into fifo
    TFT.WaitCmdfifo_empty();                    // Wait till coprocessor completes the operation

    TFT.ResetInflateFileBitmap();
    TFT.LoadInflateFileBitmap("/fs/DMC_logo_438x154.bin", ARGB4, 438, 154);
//    TFT.LoadInflateFileBitmap("/fs/DMC_logo_black_438x154.bin", RGB332, 438, 154); // smaller, scattering effect
}

void showSplashScreen(void)
{
    TFT.DLstart();                              // start a new display command list
    TFT.DL(CLEAR_COLOR_RGB(0x00, 0x00, 0x00));  // set the clear color to white
    TFT.DL(CLEAR(1, 1, 1));                     // clear buffers -> color buffer,stencil buffer, tag buffer
    TFT.DL(COLOR_RGB(0xff, 0x80, 0x00));        // set current color to gray

//    // Use bitmap
//    TFT.DL(BEGIN(BITMAPS));
//    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//    TFT.ShowBitmapByName("DMC_logo", 21, 323);

    // Use text (preserves space)
    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
    TFT.Text(240, 400, 31, OPT_CENTER, "DMC");     // text SYSTEM

    TFT.DL(DISPLAY());                          // Display the image
    TFT.Swap();                                 // Swap the current display list
    TFT.Flush_Co_Buffer();                      // Download the command list into fifo
    TFT.WaitCmdfifo_empty();                    // Wait till coprocessor completes the operation
}

void showMainPage(void)
{
//    printf("showMainPage\n");
    
    TFT.DLstart();                              // start a new display command list
    TFT.DL(CLEAR_COLOR_RGB(0x10, 0x10, 0x10));  // set the clear color to white
    TFT.DL(CLEAR(1, 1, 1));                     // clear buffers -> color buffer,stencil buffer, tag buffer
    TFT.DL(COLOR_RGB(0xff, 0xff, 0xff));  // set the clear color to white

    TFT.DL(BEGIN(BITMAPS));

// Main box
RoundedRectangle(5, 5, 229, 541, 20, 2, 0xC8, 0xC8, 0xC8, 0x00, 0x00, 0x00, 0, "");
// Black cut-out at the top
RoundedRectangle(50, 3, 140, 8, 0, 0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0, "");

// Aux box
RoundedRectangle(245, 5, 229, 541, 20, 2, 0xC8, 0xC8, 0xC8, 0x00, 0x00, 0x00, 0, "");
// Black cut-out at the top
RoundedRectangle(290, 3, 140, 8, 0, 0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0, "");

int yFuBox = 557;

// FU box
RoundedRectangle(125, yFuBox, 229, 58, 20, 2, 0xC8, 0xC8, 0xC8, 0x00, 0x00, 0x00, 0, "");

    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white

    // Build the background for main and aux
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_TL", 5,       5);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_TL", 5 + 240, 5);
//    TFT.ShowBitmapByName("BACKGROUND_01_H_25x4",  25,       5);
//    TFT.ShowBitmapByName("BACKGROUND_01_H_25x4", 190,       5);
//    TFT.ShowBitmapByName("BACKGROUND_01_H_25x4",  25 + 240, 5);
//    TFT.ShowBitmapByName("BACKGROUND_01_H_25x4", 190 + 240, 5);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_TR", 215,       5);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_TR", 215 + 240, 5);
//    TFT.ShowBitmapByName("BACKGROUND_01_V_4x535",   5,       25);
//    TFT.ShowBitmapByName("BACKGROUND_01_V_4x535", 231,       25);
//    TFT.ShowBitmapByName("BACKGROUND_01_V_4x535",   5 + 240, 25);
//    TFT.ShowBitmapByName("BACKGROUND_01_V_4x535", 231 + 240, 25);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_BL", 5,       560);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_BL", 5 + 240, 560);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_BR", 215,       560);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_BR", 215 + 240, 560);
//    TFT.ShowBitmapByName("BACKGROUND_01_H_190x4", 25,       576);
//    TFT.ShowBitmapByName("BACKGROUND_01_H_190x4", 25 + 240, 576);
    
    // Build the background for FU FAILURE box
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_TL", 125, 588);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_TR", 335, 588);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_BL", 125, 629);
//    TFT.ShowBitmapByName("BACKGROUND_01_C_20x20_BR", 335, 629);
//    TFT.ShowBitmapByName("BACKGROUND_01_V_4x21", 125, 608);
//    TFT.ShowBitmapByName("BACKGROUND_01_V_4x21", 351, 608);
//    TFT.ShowBitmapByName("BACKGROUND_01_H_190x4", 145, 588);
//    TFT.ShowBitmapByName("BACKGROUND_01_H_190x4", 145, 645);

    // Text SYSTEM at the top
    TFT.DL(COLOR_RGB(0xC8, 0xC8, 0xC8));        // set current color to gray
    TFT.Text(118,       15, 30, OPT_CENTER, "SYSTEM");     // text SYSTEM
    TFT.Text(118 + 240, 15, 30, OPT_CENTER, "SYSTEM");     // text SYSTEM
//    TFT.Text(118,       25, 30, OPT_CENTER, "RUNNING");     // text SYSTEM
//    TFT.Text(118 + 240, 25, 30, OPT_CENTER, "WARNING");     // text SYSTEM


    // Draw indicators
    
    // Pump Running Indicators (small triangles)
    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
    switch(main_indicator.pump_in_use) {
        case PUMP_IN_USE :
            TFT.ShowBitmapByName("RUN_TIME_C_ON_21_X_21",  230, 2);
            TFT.ShowBitmapByName("RUN_TIME_L_OFF_21_X_21", 207, 9);
            TFT.ShowBitmapByName("RUN_TIME_R_OFF_21_X_21", 253, 9);
            break;
        case PUMP_IN_USE_MAIN :
            TFT.ShowBitmapByName("RUN_TIME_C_OFF_21_X_21", 230, 2);
            TFT.ShowBitmapByName("RUN_TIME_L_ON_21_X_21",  207, 9);
            TFT.ShowBitmapByName("RUN_TIME_R_OFF_21_X_21", 253, 9);
            break;
        case PUMP_IN_USE_AUX :
            TFT.ShowBitmapByName("RUN_TIME_C_OFF_21_X_21", 230, 2);
            TFT.ShowBitmapByName("RUN_TIME_L_OFF_21_X_21", 207, 9);
            TFT.ShowBitmapByName("RUN_TIME_R_ON_21_X_21",  253, 9);
            break;
        default :
            // PUMP_OFF
            TFT.ShowBitmapByName("RUN_TIME_C_OFF_21_X_21", 230, 2);
            TFT.ShowBitmapByName("RUN_TIME_L_OFF_21_X_21", 207, 9);
            TFT.ShowBitmapByName("RUN_TIME_R_OFF_21_X_21", 253, 9);
    }

    // Draw indicators and buttons
    int y = 0;
    int x1 = 120;
    int x2 = 120 + 240;
    int xc = 240;
    int x1b = 10;
    int x2b = 250;
    int xcb = 130;
    uint8_t box_radius = 15;
    
    
    // MD Running indicators
    y += 65;
    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//    TFT.ShowBitmapByName("RegularButtonBlk_220x51r4t", 10,       y-25);
//    TFT.ShowBitmapByName("RegularButtonBlk_220x51r4t", 10 + 240, y-25);

RoundedRectangle(x1b, y-25+1, 219, 48, 5, 2, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0, "");
RoundedRectangle(x2b, y-25+1, 219, 48, 5, 2, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0, "");

    // SVG indicators, FT813 Font: Google Yantramanav
    // https://www.w3schools.com/howto/tryit.asp?font=Yantramanav
    // https://fonts.google.com/?query=Yantramanav
//    TFT.ShowBitmapByName("MD_RUNNING_220x51", 10,       y-27);
//    TFT.ShowBitmapByName("MD_WARNING_220x51", 10 + 240, y-27);
//    Markus Adobe Ilustrator
//            TFT.ShowBitmapByName("MD_RUNNING_230x70", 5, y-35);
//            TFT.ShowBitmapByName("MD_WARNING_230x70", 245, y-35);

    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
    switch(main_indicator.md_main_running) {
        case RUN_STATUS_RUNNING :
            TFT.ShowBitmapByName("MD_RUNNING_220x51bt", 10, y-27);
            break;
        case RUN_STATUS_WARNING :
            TFT.ShowBitmapByName("MD_WARNING_220x51bt", 10, y-27);
            break;
        case RUN_STATUS_DISABLED :
            TFT.ShowBitmapByName("MD_DISABLED_220x51bt", 10, y-27);
            break;
        case RUN_STATUS_OFF_RED :
            TFT.ShowBitmapByName("MD_OFF_Red_220x51bt", 10, y-27);
            break;
        case RUN_STATUS_OFF :
            TFT.ShowBitmapByName("MD_OFF_Grey_220x51bt", 10, y-27);
            break;
        default :
            // RUN_STATUS_BLANK: No bitmap
            break;
    }

    switch(main_indicator.md_aux_running) {
        case RUN_STATUS_RUNNING :
            TFT.ShowBitmapByName("MD_RUNNING_220x51bt", 250, y-27);
            break;
        case RUN_STATUS_WARNING :
            TFT.ShowBitmapByName("MD_WARNING_220x51bt", 250, y-27);
            break;
        case RUN_STATUS_DISABLED :
            TFT.ShowBitmapByName("MD_DISABLED_220x51bt", 250, y-27);
            break;
        case RUN_STATUS_OFF_RED :
            TFT.ShowBitmapByName("MD_OFF_Red_220x51bt", 250, y-27);
            break;
        case RUN_STATUS_OFF :
            TFT.ShowBitmapByName("MD_OFF_Grey_220x51bt", 250, y-27);
            break;
        default :
            // RUN_STATUS_BLANK: No bitmap
            break;
    }

    // PHASE FAIL
    y += 60;
    switch(main_indicator.rb_main_phase_fail) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "PHASE FAIL");     // text PHASE FAIL
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "PHASE FAIL");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "PHASE FAIL");     // text PHASE FAIL
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "PHASE FAIL");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x1, y, 30, OPT_CENTER, "PHASE FAIL");     // text PHASE FAIL
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "PHASE FAIL");
    }

    switch(main_indicator.rb_aux_phase_fail) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "PHASE FAIL");     // text PHASE FAIL
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "PHASE FAIL");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "PHASE FAIL");     // text PHASE FAIL
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "PHASE FAIL");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x2, y, 30, OPT_CENTER, "PHASE FAIL");     // text PHASE FAIL
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "PHASE FAIL");
    }

    // MAIN POWER
    y += 49;
    switch(main_indicator.rb_main_main_power) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "MAIN POWER");     // text MAIN POWER
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "MAIN POWER");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "MAIN POWER");     // text MAIN POWER
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "MAIN POWER");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x1, y, 30, OPT_CENTER, "MAIN POWER");     // text MAIN POWER
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "MAIN POWER");
    }
    
    switch(main_indicator.rb_aux_main_power) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "MAIN POWER");     // text MAIN POWER
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "MAIN POWER");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "MAIN POWER");     // text MAIN POWER
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "MAIN POWER");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x2, y, 30, OPT_CENTER, "MAIN POWER");     // text MAIN POWER
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "MAIN POWER");
    }

    // CTRL POWER
    y += 49;
    switch(main_indicator.rb_main_ctrl_power) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "CTRL POWER");     // text CTRL POWER
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "CTRL POWER");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "CTRL POWER");     // text CTRL POWER
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "CTRL POWER");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x1, y, 30, OPT_CENTER, "CTRL POWER");     // text CTRL POWER
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "CTRL POWER");
    }

    switch(main_indicator.rb_aux_ctrl_power) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "CTRL POWER");     // text CTRL POWER
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "CTRL POWER");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "CTRL POWER");     // text CTRL POWER
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "CTRL POWER");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x2, y, 30, OPT_CENTER, "CTRL POWER");     // text CTRL POWER
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "CTRL POWER");
    }

    // OIL PRESS
    y += 49;
    switch(main_indicator.rb_main_oil_press) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL PRESS");     // text OIL PRESS
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "OIL PRESS");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL PRESS");     // text OIL PRESS
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "OIL PRESS");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL PRESS");     // text OIL PRESS
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "OIL PRESS");
    }

    switch(main_indicator.rb_aux_oil_press) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL PRESS");     // text OIL PRESS
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "OIL PRESS");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL PRESS");     // text OIL PRESS
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "OIL PRESS");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL PRESS");     // text OIL PRESS
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "OIL PRESS");
    }

    // HYDR LOCK
    y += 49;
    TFT.DL(TAG(100));                             // assign TAG
    switch(main_indicator.rb_main_hydr_lock) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "HYDR LOCK");     // text HYDR LOCK
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "HYDR LOCK");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "HYDR LOCK");     // text HYDR LOCK
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "HYDR LOCK");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x1, y, 30, OPT_CENTER, "HYDR LOCK");     // text HYDR LOCK
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "HYDR LOCK");
    }

    TFT.DL(TAG(101));                             // assign TAG
    switch(main_indicator.rb_aux_hydr_lock) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "HYDR LOCK");     // text HYDR LOCK
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "HYDR LOCK");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "HYDR LOCK");     // text HYDR LOCK
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "HYDR LOCK");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x2, y, 30, OPT_CENTER, "HYDR LOCK");     // text HYDR LOCK
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "HYDR LOCK");
    }

    // OVERLOAD
    y += 49;

    switch(main_indicator.rb_main_overload) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "OVERLOAD");     // text OVERLOAD
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "OVERLOAD");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "OVERLOAD");     // text OVERLOAD
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "OVERLOAD");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x1, y, 30, OPT_CENTER, "OVERLOAD");     // text OVERLOAD
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "OVERLOAD");
    }

    switch(main_indicator.rb_aux_overload) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OVERLOAD");     // text OVERLOAD
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "OVERLOAD");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OVERLOAD");     // text OVERLOAD
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "OVERLOAD");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x2, y, 30, OPT_CENTER, "OVERLOAD");     // text OVERLOAD
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "OVERLOAD");
    }

    // OIL LEVEL
    y += 49;
    switch(main_indicator.rb_main_oil_level) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL LEVEL");     // text OIL LEVEL
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "OIL LEVEL");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL LEVEL");     // text OIL LEVEL
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "OIL LEVEL");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL LEVEL");     // text OIL LEVEL
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "OIL LEVEL");
    }

    switch(main_indicator.rb_aux_oil_level) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL LEVEL");     // text OIL LEVEL
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "OIL LEVEL");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL LEVEL");     // text OIL LEVEL
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "OIL LEVEL");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL LEVEL");     // text OIL LEVEL
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "OIL LEVEL");
    }

    // OIL FILTER
    y += 49;
    switch(main_indicator.rb_main_oil_filter) {
        case ALARM_STATUS_OFF :
            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//    TFT.DL(COLOR_RGB(0x60, 0x60, 0x60));        // set current color to white    
//    TFT.RectWH(x1b+1, y-25+1, 217, 48, 1);
//    TFT.DL(COLOR_RGB(0x80, 0x80, 0x80));        // set current color to white    
//    TFT.RectWH(x1b+1+4, y-25+1+4, 217-8, 48-8, 1);
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "OIL FILTER");
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL FILTER");     // text OIL FILTER
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "OIL FILTER");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL FILTER");     // text OIL FILTER
    RegularButton(x1b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "OIL FILTER");
    }

//    TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to white
//    TFT.Text(x1, y, 30, OPT_CENTER, "OIL FILTER");     // text OIL FILTER



    switch(main_indicator.rb_aux_oil_filter) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL FILTER");     // text OIL FILTER
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0x80, 0x80, 0x80, 0, "OIL FILTER");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL FILTER");     // text OIL FILTER
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFF, 0xFF, 0x00, 0, "OIL FILTER");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL FILTER");     // text OIL FILTER
    RegularButton(x2b, y-25+1, 219, 48, 1, 0, 0xFE, 0x00, 0x00, 1, "OIL FILTER");
    }

    // OIL TEMP
    y += 49;
    switch(main_indicator.rb_main_oil_temp) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0r10t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL TEMP");     // text OIL TEMP
    RegularButton(x1b, y-25+1, 219, 48, box_radius, 1, 0x80, 0x80, 0x80, 0, "OIL TEMP");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0r10t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL TEMP");     // text OIL TEMP
    RegularButton(x1b, y-25+1, 219, 48, box_radius, 1, 0xFF, 0xFF, 0x00, 0, "OIL TEMP");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0r10t", x1b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x1, y, 30, OPT_CENTER, "OIL TEMP");     // text OIL TEMP
    RegularButton(x1b, y-25+1, 219, 48, box_radius, 1, 0xFE, 0x00, 0x00, 1, "OIL TEMP");
    }

//    TFT.Text(x1, y, 30, OPT_CENTER, "OIL TEMP");     // text OIL TEMP

    switch(main_indicator.rb_aux_oil_temp) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r0r10t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL TEMP");     // text OIL TEMP
    RegularButton(x2b, y-25+1, 219, 48, box_radius, 1, 0x80, 0x80, 0x80, 0, "OIL TEMP");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r0r10t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL TEMP");     // text OIL TEMP
    RegularButton(x2b, y-25+1, 219, 48, box_radius, 1, 0xFF, 0xFF, 0x00, 0, "OIL TEMP");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r0r10t", x2b, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(x2, y, 30, OPT_CENTER, "OIL TEMP");     // text OIL TEMP
    RegularButton(x2b, y-25+1, 219, 48, box_radius, 1, 0xFE, 0x00, 0x00, 1, "OIL TEMP");
    }

    // FU FAILURE
    y = yFuBox; // 557
    switch(main_indicator.rb_fu_failure) {
        case ALARM_STATUS_OFF :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonGray_220x51r10t", xcb, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(xc, y, 30, OPT_CENTER, "FU FAILURE");     // text FU FAILURE
    RegularButton(xcb, y+5, 219, 48, box_radius, 2, 0x80, 0x80, 0x80, 0, "FU FAILURE");
            break;
        case ALARM_STATUS_WARNING :
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonYel_220x51r10t", xcb, y-25);
//            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
//            TFT.Text(xc, y, 30, OPT_CENTER, "FU FAILURE");     // text FU FAILURE
    RegularButton(xcb, y+5, 219, 48, box_radius, 2, 0xFF, 0xFF, 0x00, 0, "FU FAILURE");
            break;
        default : // ALARM_STATUS_FAILURE
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.ShowBitmapByName("RegularButtonRed_220x51r10t", xcb, y-25);
//            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
//            TFT.Text(xc, y, 30, OPT_CENTER, "FU FAILURE");     // text FU FAILURE
    RegularButton(xcb, y+5, 219, 48, box_radius, 2, 0xFE, 0x00, 0x00, 1, "FU FAILURE");
    }


    // BUTTON SET
    TFT.DL(TAG(BUTTON_SET_TAG));                             // assign TAG
    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
    if (main_button.set_pressed == 0) {
        TFT.ShowBitmapByName("SwitchOn_115x66_t", 5,   y-4);
        TFT.DL(COLOR_RGB(0xB0, 0xB0, 0xB0));        // set current color to white
    } else {
        TFT.ShowBitmapByName("SwitchOff_115x66_t", 5,   y-4);
        TFT.DL(COLOR_RGB(0x90, 0x90, 0x90));        // set current color to white
    }
//    TFT.Text(63, y+1, 30, OPT_CENTER, "SET");         // text SET
    TFT.ShowBitmapByName("settings_40x40", 42,   y-4+13);

    // BUTTON DIM
    TFT.DL(TAG(BUTTON_DIM_TAG));                             // assign TAG
    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
    if (main_button.dim_pressed == 0) {
        TFT.ShowBitmapByName("SwitchOn_115x66_t", 360, y-4);
        TFT.DL(COLOR_RGB(0xB0, 0xB0, 0xB0));        // set current color to white
    } else {
        TFT.ShowBitmapByName("SwitchOff_115x66_t", 360, y-4);
        TFT.DL(COLOR_RGB(0x90, 0x90, 0x90));        // set current color to white
    }
//    TFT.Text(418, y+1, 30, OPT_CENTER, "DIM");        // text DIM
    TFT.ShowBitmapByName("light-bulb_40x40", 397,   y-4+13);


    // Accept Switches
    y = 623;
    // BUTTON ACCEPT ALARM
    TFT.DL(TAG(BUTTON_ACCEPT_ALARM_TAG));                             // assign TAG
    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
    if (main_button.accept_alarm_pressed == 0)
        TFT.ShowBitmapByName("SwitchOn_234x132", 3, y);
    else
        TFT.ShowBitmapByName("SwitchOff_234x132", 3, y);
    TFT.Text(x1, y+49, 30, OPT_CENTER, "ACCEPT");     // text OIL PRESS
    TFT.Text(x1, y+84, 30, OPT_CENTER, "ALARM");     // text OIL PRESS

    // BUTTON ACCEPT HORN
    TFT.DL(TAG(BUTTON_ACCEPT_HORN_TAG));                             // assign TAG
    TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
    if (main_button.accept_horn_pressed == 0)
        TFT.ShowBitmapByName("SwitchOn_234x132", 3 + 240, y);
    else
        TFT.ShowBitmapByName("SwitchOff_234x132", 3 + 240, y);
    TFT.Text(x2, y+49, 30, OPT_CENTER, "ACCEPT");     // text OIL PRESS
    TFT.Text(x2, y+84, 30, OPT_CENTER, "HORN");     // text OIL PRESS

    TFT.DL(DISPLAY());                          // Display the image
    TFT.Swap();                                 // Swap the current display list
    TFT.Flush_Co_Buffer();                      // Download the command list into fifo
    TFT.WaitCmdfifo_empty();                    // Wait till coprocessor completes the operation
}

void RegularButton(int16_t x0, int16_t y0, int16_t w, int16_t h, int16_t corner, uint8_t style, uint8_t R, uint8_t G, uint8_t B, uint8_t text_color, char *text)
{
    uint8_t linewidth = 4;
    uint8_t corner_inner = corner - linewidth;
    if (corner_inner < 1) {
       corner_inner = 1;
    }
    uint8_t Rd = R * 0.5;
    uint8_t Gd = G * 0.5;
    uint8_t Bd = B * 0.5;
    uint16_t x1 = x0 + w / 2;
    uint16_t y1 = y0 + h / 2;
    if (style == 0) {
        TFT.DL(COLOR_RGB(Rd, Gd, Bd));        // set current color to white    
        TFT.RectWH(x0, y0, w, h, 1);
        TFT.DL(COLOR_RGB(R, G, B));        // set current color to white    
        TFT.RectWH(x0+linewidth, y0+linewidth, w-linewidth*2, h-linewidth*2, 1);
    } else if (style == 1) {
        if (corner < linewidth) {
            corner = linewidth;
        }
        if (corner_inner < 1) {
            corner_inner = 1;
        }
        TFT.DL(COLOR_RGB(Rd, Gd, Bd));        // set current color to white    
        TFT.RectWH(x0, y0, corner, corner, 1);              // left top rect
        TFT.RectWH(x0+w-corner, y0, corner, corner, 1);     // right top rect
        TFT.RectWH(x0, y0, w, h, corner);
        TFT.DL(COLOR_RGB(R, G, B));        // set current color to white    
        TFT.RectWH(x0+linewidth, y0+linewidth, corner, corner, 1);                          // left top rect
        TFT.RectWH(x0+w-linewidth-corner, y0+linewidth, corner, corner, 1);    // right top rect
        TFT.RectWH(x0+linewidth, y0+linewidth, w-linewidth*2, h-linewidth*2, corner_inner);
    } else if (style == 2) {
        if (corner < linewidth) {
            corner = linewidth;
        }
        if (corner_inner < 1) {
            corner_inner = 1;
        }
        TFT.DL(COLOR_RGB(Rd, Gd, Bd));        // set current color to white    
        TFT.RectWH(x0, y0, w, h, corner);
        TFT.DL(COLOR_RGB(R, G, B));        // set current color to white    
        TFT.RectWH(x0+linewidth, y0+linewidth, w-linewidth*2, h-linewidth*2, corner_inner);
    }
    if (text_color == 0) {
        TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
    }
    else {
        TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
    }
    TFT.Text(x1, y1, 30, OPT_CENTER, text);     // text OIL TEMP   
}

void RoundedRectangle(int16_t x0, int16_t y0, int16_t w, int16_t h, int16_t corner, uint8_t style, uint8_t Ro, uint8_t Go, uint8_t Bo, uint8_t Ri, uint8_t Gi, uint8_t Bi, uint8_t text_color, char *text)
{
    uint8_t linewidth = 4;
    uint8_t corner_inner = corner - linewidth;
    uint16_t x1 = x0 + w / 2;
    uint16_t y1 = y0 + h / 2;
    if (style == 0) {
        TFT.DL(COLOR_RGB(Ro, Go, Bo));        // set current color to white    
        TFT.RectWH(x0, y0, w, h, 1);
        TFT.DL(COLOR_RGB(Ri, Gi, Bi));        // set current color to white    
        TFT.RectWH(x0+linewidth, y0+linewidth, w-linewidth*2, h-linewidth*2, 1);
    } else if (style == 1) {
        if (corner < linewidth) {
            corner = linewidth;
        }
        if (corner_inner < linewidth) {
            corner_inner = linewidth;
        }
        TFT.DL(COLOR_RGB(Ro, Go, Bo));        // set current color to white    
        TFT.RectWH(x0, y0, corner, corner, 1);
        TFT.RectWH(x0+w-corner, y0, corner, corner, 1);
        TFT.RectWH(x0, y0, w, h, corner);
        TFT.DL(COLOR_RGB(Ri, Gi, Bi));        // set current color to white    
        TFT.RectWH(x0+linewidth, y0+linewidth, corner, corner, 1);
        TFT.RectWH(x0+linewidth+w-corner-corner_inner, y0+linewidth, corner, corner, 1);
        TFT.RectWH(x0+linewidth, y0+linewidth, w-linewidth*2, h-linewidth*2, corner_inner);
    } else if (style == 2) {
        if (corner < linewidth) {
            corner = linewidth;
        }
        if (corner_inner < linewidth) {
            corner_inner = linewidth;
        }
        TFT.DL(COLOR_RGB(Ro, Go, Bo));        // set current color to white    
        TFT.RectWH(x0, y0, w, h, corner);
        TFT.DL(COLOR_RGB(Ri, Gi, Bi));        // set current color to white    
        TFT.RectWH(x0+linewidth, y0+linewidth, w-linewidth*2, h-linewidth*2, corner_inner);
    }
    // Text
//    if (strlen(text) > 0) {
        if (text_color == 0) {
            TFT.DL(COLOR_RGB(0x00, 0x00, 0x00));        // set current color to black
        }
        else {
            TFT.DL(COLOR_RGB(0xFF, 0xFF, 0xFF));        // set current color to white
        }
        TFT.Text(x1, y1, 30, OPT_CENTER, text);     // text   
//    }
}

void updateAlarmLights(void)
{
    // Set indicators to OFF, BLINK, or STEADY_OFF ON
    // Status can be OFF, WARNING, and FAILURE
    // Update screen if something changed
    
    bool updatePage = false;
    if (blinker.read() >= 0.5) {
        blinker.reset();
        
        
        // Blink all indicators synchonously
        mainBlink = !mainBlink;
                
        // All Main and Aux alarms
        for(int system = MAIN_SYSTEM; system <= GLOBAL_SYSTEM; system++) {
            // MAIN_SYSTEM, AUX_SYSTEM, GLOBAL_SYSTEM
            for(int alarm = PHASE_FAIL; alarm <= FU_FAILURE; alarm++) {
                // PHASE_FAIL, MAIN_POWER, CTRL_POWER, OIL_PRESS, HYDR_LOCK,
                // OVERLOAD, OIL_LEVEL, OIL_FILTER, OIL_TEMP, FU_FAILURE
    
                if (getAlarmBlinkStatus((System)system, (Alarm)alarm) == STEADY_OFF) {
                    setAlarmStatus((System)system, (Alarm)alarm, ALARM_STATUS_OFF);
                }
                if (getAlarmBlinkStatus((System)system, (Alarm)alarm) == BLINK_WARNING_ON) {
                    toggleAlarmStatus((System)system, (Alarm)alarm, ALARM_STATUS_WARNING);
                }
                if (getAlarmBlinkStatus((System)system, (Alarm)alarm) == STEADY_WARNING_ON) {
                    setAlarmStatus((System)system, (Alarm)alarm, ALARM_STATUS_WARNING);
                }
                if (getAlarmBlinkStatus((System)system, (Alarm)alarm) == BLINK_FAILURE_ON) {
                    toggleAlarmStatus((System)system, (Alarm)alarm, ALARM_STATUS_FAILURE);
                }
                if (getAlarmBlinkStatus((System)system, (Alarm)alarm) == STEADY_FAILURE_ON) {
                    setAlarmStatus((System)system, (Alarm)alarm, ALARM_STATUS_FAILURE);
                }
            }
            if (system != GLOBAL_SYSTEM) {
//                printf("getPumpRunningBlinkStatus(%d) = %d\n", system, getPumpRunningBlinkStatus((System)system));
                if (getPumpRunningBlinkStatus((System)system) == STEADY_OFF) {
                    setPumpRunningStatus((System)system, RUN_STATUS_OFF);
                }
                if (getPumpRunningBlinkStatus((System)system) == BLINK_WARNING_ON) {
                    togglePumpRunningStatus((System)system, RUN_STATUS_WARNING);
                }
                if (getPumpRunningBlinkStatus((System)system) == STEADY_WARNING_ON) {
                    setPumpRunningStatus((System)system, RUN_STATUS_WARNING);
                }
                if (getPumpRunningBlinkStatus((System)system) == BLINK_DISABLED_ON) {
                    togglePumpRunningStatus((System)system, RUN_STATUS_DISABLED);
                }
                if (getPumpRunningBlinkStatus((System)system) == STEADY_DISABLED_ON) {
                    setPumpRunningStatus((System)system, RUN_STATUS_DISABLED);
                }
                if (getPumpRunningBlinkStatus((System)system) == BLINK_RUNNING_ON) {
                    togglePumpRunningStatus((System)system, RUN_STATUS_RUNNING);
                }
                if (getPumpRunningBlinkStatus((System)system) == STEADY_RUNNING_ON) {
                    setPumpRunningStatus((System)system, RUN_STATUS_RUNNING);
                }
                if (getPumpRunningBlinkStatus((System)system) == BLINK_OFF_RED_ON) {
                    togglePumpRunningStatus((System)system, RUN_STATUS_OFF_RED);
                }
                if (getPumpRunningBlinkStatus((System)system) == STEADY_OFF_RED_ON) {
                    setPumpRunningStatus((System)system, RUN_STATUS_OFF_RED);
                }
            }    
        }
        if (checkIndicatorsChanged()) {
            main_indicator_previous = main_indicator;
            updatePage = true;
        }
        if (updatePage) {
            showMainPage();
        }
    }
}

void processButtonPressed(uint16_t tagval)
{
    switch(tagval) {
        case BUTTON_ACCEPT_ALARM_TAG :
            setButtonAcceptAlarm(BUTTON_PRESSED);       // Flag Accept Alarm button is in pressed state
            break;
        case BUTTON_ACCEPT_HORN_TAG :
            setButtonAcceptHorn(BUTTON_PRESSED);        // Flag Accept Horn button is in pressed state
            break;
        case BUTTON_SET_TAG :
            setButtonSet(BUTTON_PRESSED);               // Flag Set button is in pressed state
//            testIndicators();                   // Jack TEST
            break;
        case BUTTON_DIM_TAG :
            setButtonDim(BUTTON_PRESSED);               // Flag Dim button is in pressed state
            toggleDisplayBrighnessSelect();             // Toggle display brightness
            break;
        case 100 :
            testIndicators();                   // Jack TEST
            break;
    }
}

void processButtonReleased(void)
{
    if (getButtonAcceptAlarm() != BUTTON_RELEASED) {
        setButtonAcceptAlarm(BUTTON_RELEASED);          // Flag Accept Alarm button is in released state
    }
    if (getButtonAcceptHorn() != BUTTON_RELEASED) {
        setButtonAcceptHorn(BUTTON_RELEASED);           // Flag Accept Horn button is in released state
    }
    if (getButtonSet() != BUTTON_RELEASED) {
        setButtonSet(BUTTON_RELEASED);                  // Flag Set button is in released state
    }
    if (getButtonDim() != BUTTON_RELEASED) {
        setButtonDim(BUTTON_RELEASED);                  // Flag Dim button is in released state
    }
}

void backupAlarms(void)
{
    main_indicator_backup = main_indicator;
}

void restoreAlarms(void)
{
    main_indicator = main_indicator_backup;
}

uint8_t getDisplayBrighnessSelect(void)
{
    return brightnessSelect;
}

void setDisplayBrighnessSelect(uint8_t select)
{
    brightnessSelect = select;
    if (select == BIGHTNESS_SELECT_LOW) {
        TFT.SetBacklight(brightnessLow); // Brightness Low
    }
    if (select == BIGHTNESS_SELECT_HIGH) {
        TFT.SetBacklight(brightnessHigh); // Brightness High
    }
}

void toggleDisplayBrighnessSelect(void)
{
    if (getDisplayBrighnessSelect() == BIGHTNESS_SELECT_HIGH) {
        setDisplayBrighnessSelect(BIGHTNESS_SELECT_LOW);
    } else {
        setDisplayBrighnessSelect(BIGHTNESS_SELECT_HIGH);
    }
}

void setDisplayBrighnessHigh(uint8_t value)
{
    brightnessHigh = value;
}

void setDisplayBrighnessLow(uint8_t value)
{
    brightnessLow = value;
}

uint8_t getButtonAcceptAlarm(void)
{
    return main_button.accept_alarm_pressed;
}

void setButtonAcceptAlarm(uint8_t status)
{
    main_button.accept_alarm_pressed = status;
}

uint8_t getButtonAcceptHorn(void)
{
    return main_button.accept_horn_pressed;
}

void setButtonAcceptHorn(uint8_t status)
{
    main_button.accept_horn_pressed = status;
}

uint8_t getButtonSet(void)
{
    return main_button.set_pressed;
}

void setButtonSet(uint8_t status)
{
    main_button.set_pressed = status;
}

uint8_t getButtonDim(void)
{
    return main_button.dim_pressed;
}

void setButtonDim(uint8_t status)
{
    main_button.dim_pressed = status;
}

Pump getPumpInUse(void)
{
    return main_indicator.pump_in_use;
}

void setPumpInUse(Pump status)
{
    main_indicator.pump_in_use = status;
}

IndicatorLightStatus getPumpInUseBlinkStatus(void)
{
    return main_indicator.pump_in_use_light;
}

void setPumpInUseBlinkStatus(IndicatorLightStatus status)
{
    main_indicator.pump_in_use_light = status;
}



IndicatorLightStatus getPumpRunningBlinkStatus(System system)
{
    if (system == MAIN_SYSTEM) {
       return main_indicator.md_main_running_light;
    }
    if (system == AUX_SYSTEM) {
        return main_indicator.md_aux_running_light;
    }
    return STEADY_OFF;
}

void setPumpRunningBlinkStatus(System system, IndicatorLightStatus status)
{
    if (system == MAIN_SYSTEM) {
        main_indicator.md_main_running_light = status;
    } else if (system == AUX_SYSTEM) {
        main_indicator.md_aux_running_light = status;
    }
}

IndicatorRunStatus getPumpRunningStatus(System system)
{
    if (system == MAIN_SYSTEM) {
        return main_indicator.md_main_running;
    } else if (system == AUX_SYSTEM) {
        return main_indicator.md_aux_running;
    }
    return RUN_STATUS_BLANK;
}

void setPumpRunningStatus(System system, IndicatorRunStatus status)
{
    if (system == MAIN_SYSTEM) {
        main_indicator.md_main_running = status;
    } else if (system == AUX_SYSTEM) {
        main_indicator.md_aux_running = status;
    }
}

void togglePumpRunningStatus(System system, IndicatorRunStatus status)
{
    if (mainBlink) {
        setPumpRunningStatus(system, status);
    } else {       
        setPumpRunningStatus(system, RUN_STATUS_BLANK);
    }
}

IndicatorLightStatus getAlarmBlinkStatus(System system, Alarm alarm)
{
    if (system == MAIN_SYSTEM) {
        // MAIN_SYSTEM
        switch(alarm) {
            case PHASE_FAIL :
                return main_indicator.rb_main_phase_fail_light;
            case MAIN_POWER :
                return main_indicator.rb_main_main_power_light;
            case CTRL_POWER :
                return main_indicator.rb_main_ctrl_power_light;
            case OIL_PRESS :
                return main_indicator.rb_main_oil_press_light;
            case HYDR_LOCK :
                return main_indicator.rb_main_hydr_lock_light;
            case OVERLOAD :
                return main_indicator.rb_main_overload_light;
            case OIL_LEVEL :
                return main_indicator.rb_main_oil_level_light;
            case OIL_FILTER :
                return main_indicator.rb_main_oil_filter_light;
            case OIL_TEMP :
                return main_indicator.rb_main_oil_temp_light;
            default :
                return STEADY_OFF;
        }
    } else if (system == AUX_SYSTEM) {
        // AUX_SYSTEM
        switch(alarm) {
            case PHASE_FAIL :
                return main_indicator.rb_aux_phase_fail_light;
            case MAIN_POWER :
                return main_indicator.rb_aux_main_power_light;
            case CTRL_POWER :
                return main_indicator.rb_aux_ctrl_power_light;
            case OIL_PRESS :
                return main_indicator.rb_aux_oil_press_light;
            case HYDR_LOCK :
                return main_indicator.rb_aux_hydr_lock_light;
            case OVERLOAD :
                return main_indicator.rb_aux_overload_light;
            case OIL_LEVEL :
                return main_indicator.rb_aux_oil_level_light;
            case OIL_FILTER :
                return main_indicator.rb_aux_oil_filter_light;
            case OIL_TEMP :
                return main_indicator.rb_aux_oil_temp_light;
            default :
                return STEADY_OFF;
        }
    } else if (system == GLOBAL_SYSTEM) {
        // GLOBAL_SYSTEM
        switch(alarm) {
            case FU_FAILURE :
                return main_indicator.rb_fu_failure_light;
            default :
                return STEADY_OFF;
        }
    }
    return STEADY_OFF;
}

void setAlarmBlinkStatus(System system, Alarm alarm, IndicatorLightStatus status)
{
    if (system == MAIN_SYSTEM) {
        // MAIN_SYSTEM
        switch(alarm) {
            case PHASE_FAIL :
                main_indicator.rb_main_phase_fail_light = status;
                break;
            case MAIN_POWER :
                main_indicator.rb_main_main_power_light = status;
                break;
            case CTRL_POWER :
                main_indicator.rb_main_ctrl_power_light = status;
                break;
            case OIL_PRESS :
                main_indicator.rb_main_oil_press_light = status;
                break;
            case HYDR_LOCK :
                main_indicator.rb_main_hydr_lock_light = status;
                break;
            case OVERLOAD :
                main_indicator.rb_main_overload_light = status;
                break;
            case OIL_LEVEL :
                main_indicator.rb_main_oil_level_light = status;
                break;
            case OIL_FILTER :
                main_indicator.rb_main_oil_filter_light = status;
                break;
            case OIL_TEMP :
                main_indicator.rb_main_oil_temp_light = status;
                break;
        }
    } else if (system == AUX_SYSTEM) {
        // AUX_SYSTEM
        switch(alarm) {
            case PHASE_FAIL :
                main_indicator.rb_aux_phase_fail_light = status;
                break;
            case MAIN_POWER :
                main_indicator.rb_aux_main_power_light = status;
                break;
            case CTRL_POWER :
                main_indicator.rb_aux_ctrl_power_light = status;
                break;
            case OIL_PRESS :
                main_indicator.rb_aux_oil_press_light = status;
                break;
            case HYDR_LOCK :
                main_indicator.rb_aux_hydr_lock_light = status;
                break;
            case OVERLOAD :
                main_indicator.rb_aux_overload_light = status;
                break;
            case OIL_LEVEL :
                main_indicator.rb_aux_oil_level_light = status;
                break;
            case OIL_FILTER :
                main_indicator.rb_aux_oil_filter_light = status;
                break;
            case OIL_TEMP :
                main_indicator.rb_aux_oil_temp_light = status;
                break;
        }
    } else if (system == GLOBAL_SYSTEM) {
        // GLOBAL_SYSTEM
        switch(alarm) {
            case FU_FAILURE :
                main_indicator.rb_fu_failure_light = status;
                break;
        }
    }
}

IndicatorAlarmStatus getAlarmStatus(System system, Alarm alarm)
{
    if (system == MAIN_SYSTEM) {
        // MAIN_SYSTEM
        switch(alarm) {
            case PHASE_FAIL :
                return main_indicator.rb_main_phase_fail;
            case MAIN_POWER :
                return main_indicator.rb_main_main_power;
            case CTRL_POWER :
                return main_indicator.rb_main_ctrl_power;
            case OIL_PRESS :
                return main_indicator.rb_main_oil_press;
            case HYDR_LOCK :
                return main_indicator.rb_main_hydr_lock;
            case OVERLOAD :
                return main_indicator.rb_main_overload;
            case OIL_LEVEL :
                return main_indicator.rb_main_oil_level;
            case OIL_FILTER :
                return main_indicator.rb_main_oil_filter;
            case OIL_TEMP :
                return main_indicator.rb_main_oil_temp;
            default :
                return ALARM_STATUS_OFF;
        }
    } else if (system == AUX_SYSTEM) {
        // AUX_SYSTEM
        switch(alarm) {
            case PHASE_FAIL :
                return main_indicator.rb_aux_phase_fail;
            case MAIN_POWER :
                return main_indicator.rb_aux_main_power;
            case CTRL_POWER :
                return main_indicator.rb_aux_ctrl_power;
            case OIL_PRESS :
                return main_indicator.rb_aux_oil_press;
            case HYDR_LOCK :
                return main_indicator.rb_aux_hydr_lock;
            case OVERLOAD :
                return main_indicator.rb_aux_overload;
            case OIL_LEVEL :
                return main_indicator.rb_aux_oil_level;
            case OIL_FILTER :
                return main_indicator.rb_aux_oil_filter;
            case OIL_TEMP :
                return main_indicator.rb_aux_oil_temp;
            default :
                return ALARM_STATUS_OFF;
        }
    } else if (system == GLOBAL_SYSTEM) {
        // GLOBAL_SYSTEM
        switch(alarm) {
            case FU_FAILURE :
                return main_indicator.rb_fu_failure;
            default :
                return ALARM_STATUS_OFF;
        }
    }
    return ALARM_STATUS_OFF;
}

void setAlarmStatus(System system, Alarm alarm, IndicatorAlarmStatus status)
{
    if (system == MAIN_SYSTEM) {
        // MAIN_SYSTEM
        switch(alarm) {
            case PHASE_FAIL :
                main_indicator.rb_main_phase_fail = status;
                break;
            case MAIN_POWER :
                main_indicator.rb_main_main_power = status;
                break;
            case CTRL_POWER :
                main_indicator.rb_main_ctrl_power = status;
                break;
            case OIL_PRESS :
                main_indicator.rb_main_oil_press = status;
                break;
            case HYDR_LOCK :
                main_indicator.rb_main_hydr_lock = status;
                break;
            case OVERLOAD :
                main_indicator.rb_main_overload = status;
                break;
            case OIL_LEVEL :
                main_indicator.rb_main_oil_level = status;
                break;
            case OIL_FILTER :
                main_indicator.rb_main_oil_filter = status;
                break;
            case OIL_TEMP :
                main_indicator.rb_main_oil_temp = status;
                break;
        }
    } else if (system == AUX_SYSTEM) {
        // AUX_SYSTEM
        switch(alarm) {
            case PHASE_FAIL :
                main_indicator.rb_aux_phase_fail = status;
                break;
            case MAIN_POWER :
                main_indicator.rb_aux_main_power = status;
                break;
            case CTRL_POWER :
                main_indicator.rb_aux_ctrl_power = status;
                break;
            case OIL_PRESS :
                main_indicator.rb_aux_oil_press = status;
                break;
            case HYDR_LOCK :
                main_indicator.rb_aux_hydr_lock = status;
                break;
            case OVERLOAD :
                main_indicator.rb_aux_overload = status;
                break;
            case OIL_LEVEL :
                main_indicator.rb_aux_oil_level = status;
                break;
            case OIL_FILTER :
                main_indicator.rb_aux_oil_filter = status;
                break;
            case OIL_TEMP :
                main_indicator.rb_aux_oil_temp = status;
                break;
        }
    } else if (system == GLOBAL_SYSTEM) {
        // GLOBAL_SYSTEM
        switch(alarm) {
            case FU_FAILURE :
                main_indicator.rb_fu_failure = status;
                break;
        }
    }
}

void toggleAlarmStatus(System system, Alarm alarm, IndicatorAlarmStatus status)
{
    int changed = false;
    if (mainBlink) {
        setAlarmStatus(system, alarm, status);
    } else {       
        setAlarmStatus(system, alarm, ALARM_STATUS_OFF);
    }
}

bool checkIndicatorsChanged(void)
{
    bool changed = false;
    
    // Check if anything on the Main page was chnaged, so it can be refreshed
    // C provides no language facilities to compare two instances of structs for equality (in standard C)
    // Problems with memcmp: Structures can be padded, and the contents of padding bytes are undefined,
    // dynamically allocated memory pointed to by struct members, and no guarantee of contiguity.
    // memcmp doesn't know this and will blindly compare all bytes.
    // Don't do this:
    // uint8_t ret = memcmp(&main_indicator, &main_indicator_previous, sizeof(main_indicator));
    // if (ret != 0) {
    //     changed = true;
    // }
    // The only thing to do is compare each member

    // The safest ways is to compare member for member (can exclude something, intended or not intended)
    if (main_indicator.md_main_running != main_indicator_previous.md_main_running) {
        changed = true;
    }
    if (main_indicator.md_main_running_light != main_indicator_previous.md_main_running_light) {
        changed = true;
    }
    if (main_indicator.rb_main_phase_fail != main_indicator_previous.rb_main_phase_fail) {
        changed = true;
    }
    if (main_indicator.rb_main_phase_fail_light != main_indicator_previous.rb_main_phase_fail_light) {
        changed = true;
    }
    if (main_indicator.rb_main_main_power != main_indicator_previous.rb_main_main_power) {
        changed = true;
    }
    if (main_indicator.rb_main_main_power_light != main_indicator_previous.rb_main_main_power_light) {
        changed = true;
    }
    if (main_indicator.rb_main_ctrl_power != main_indicator_previous.rb_main_ctrl_power) {
        changed = true;
    }
    if (main_indicator.rb_main_ctrl_power_light != main_indicator_previous.rb_main_ctrl_power_light) {
        changed = true;
    }
    if (main_indicator.rb_main_oil_press != main_indicator_previous.rb_main_oil_press) {
        changed = true;
    }
    if (main_indicator.rb_main_oil_press_light != main_indicator_previous.rb_main_oil_press_light) {
        changed = true;
    }
    if (main_indicator.rb_main_hydr_lock != main_indicator_previous.rb_main_hydr_lock) {
        changed = true;
    }
    if (main_indicator.rb_main_hydr_lock_light != main_indicator_previous.rb_main_hydr_lock_light) {
        changed = true;
    }
    if (main_indicator.rb_main_overload != main_indicator_previous.rb_main_overload) {
        changed = true;
    }
    if (main_indicator.rb_main_overload_light != main_indicator_previous.rb_main_overload_light) {
        changed = true;
    }
    if (main_indicator.rb_main_oil_level != main_indicator_previous.rb_main_oil_level) {
        changed = true;
    }
    if (main_indicator.rb_main_oil_level_light != main_indicator_previous.rb_main_oil_level_light) {
        changed = true;
    }
    if (main_indicator.rb_main_oil_filter != main_indicator_previous.rb_main_oil_filter) {
        changed = true;
    }
    if (main_indicator.rb_main_oil_filter_light != main_indicator_previous.rb_main_oil_filter_light) {
        changed = true;
    }
    if (main_indicator.rb_main_oil_temp != main_indicator_previous.rb_main_oil_temp) {
        changed = true;
    }
    if (main_indicator.rb_main_oil_temp_light != main_indicator_previous.rb_main_oil_temp_light) {
        changed = true;
    }
    
    if (main_indicator.md_aux_running != main_indicator_previous.md_aux_running) {
        changed = true;
    }
    if (main_indicator.md_aux_running_light != main_indicator_previous.md_aux_running_light) {
        changed = true;
    }
    if (main_indicator.rb_aux_phase_fail != main_indicator_previous.rb_aux_phase_fail) {
        changed = true;
    }
    if (main_indicator.rb_aux_phase_fail_light != main_indicator_previous.rb_aux_phase_fail_light) {
        changed = true;
    }
    if (main_indicator.rb_aux_main_power != main_indicator_previous.rb_aux_main_power) {
        changed = true;
    }
    if (main_indicator.rb_aux_main_power_light != main_indicator_previous.rb_aux_main_power_light) {
        changed = true;
    }
    if (main_indicator.rb_aux_ctrl_power != main_indicator_previous.rb_aux_ctrl_power) {
        changed = true;
    }
    if (main_indicator.rb_aux_ctrl_power_light != main_indicator_previous.rb_aux_ctrl_power_light) {
        changed = true;
    }
    if (main_indicator.rb_aux_oil_press != main_indicator_previous.rb_aux_oil_press) {
        changed = true;
    }
    if (main_indicator.rb_aux_oil_press_light != main_indicator_previous.rb_aux_oil_press_light) {
        changed = true;
    }
    if (main_indicator.rb_aux_hydr_lock != main_indicator_previous.rb_aux_hydr_lock) {
        changed = true;
    }
    if (main_indicator.rb_aux_hydr_lock_light != main_indicator_previous.rb_aux_hydr_lock_light) {
        changed = true;
    }
    if (main_indicator.rb_aux_overload != main_indicator_previous.rb_aux_overload) {
        changed = true;
    }
    if (main_indicator.rb_aux_overload_light != main_indicator_previous.rb_aux_overload_light) {
        changed = true;
    }
    if (main_indicator.rb_aux_oil_level != main_indicator_previous.rb_aux_oil_level) {
        changed = true;
    }
    if (main_indicator.rb_aux_oil_level_light != main_indicator_previous.rb_aux_oil_level_light) {
        changed = true;
    }
    if (main_indicator.rb_aux_oil_filter != main_indicator_previous.rb_aux_oil_filter) {
        changed = true;
    }
    if (main_indicator.rb_aux_oil_filter_light != main_indicator_previous.rb_aux_oil_filter_light) {
        changed = true;
    }
    if (main_indicator.rb_aux_oil_temp != main_indicator_previous.rb_aux_oil_temp) {
        changed = true;
    }
    if (main_indicator.rb_aux_oil_temp_light != main_indicator_previous.rb_aux_oil_temp_light) {
        changed = true;
    }
    if (main_indicator.rb_fu_failure != main_indicator_previous.rb_fu_failure) {
        changed = true;
    }
    if (main_indicator.rb_fu_failure_light != main_indicator_previous.rb_fu_failure_light) {
        changed = true;
    }
    if (main_indicator.pump_in_use != main_indicator_previous.pump_in_use) {
        changed = true;
    }
    if (main_indicator.pump_in_use_light != main_indicator_previous.pump_in_use_light) {
        changed = true;
    }
   
    return changed;
}

void testIndicators(void)
{
    float delay = 0.5;
    backupAlarms();

    setPumpInUse(PUMP_OFF);
    setPumpRunningStatus(MAIN_SYSTEM, RUN_STATUS_OFF);
    setPumpRunningStatus(AUX_SYSTEM, RUN_STATUS_OFF);
    setAlarmStatus(MAIN_SYSTEM, PHASE_FAIL, ALARM_STATUS_OFF);
    setAlarmStatus(AUX_SYSTEM, PHASE_FAIL, ALARM_STATUS_OFF);
    setAlarmStatus(MAIN_SYSTEM, MAIN_POWER, ALARM_STATUS_OFF);
    setAlarmStatus(AUX_SYSTEM, MAIN_POWER, ALARM_STATUS_OFF);
    setAlarmStatus(MAIN_SYSTEM, CTRL_POWER, ALARM_STATUS_OFF);
    setAlarmStatus(AUX_SYSTEM, CTRL_POWER, ALARM_STATUS_OFF);
    setAlarmStatus(MAIN_SYSTEM, OIL_PRESS, ALARM_STATUS_OFF);
    setAlarmStatus(AUX_SYSTEM, OIL_PRESS, ALARM_STATUS_OFF);
    setAlarmStatus(MAIN_SYSTEM, HYDR_LOCK, ALARM_STATUS_OFF);
    setAlarmStatus(AUX_SYSTEM, HYDR_LOCK, ALARM_STATUS_OFF);
    setAlarmStatus(MAIN_SYSTEM, OVERLOAD, ALARM_STATUS_OFF);
    setAlarmStatus(AUX_SYSTEM, OVERLOAD, ALARM_STATUS_OFF);
    setAlarmStatus(MAIN_SYSTEM, OIL_LEVEL, ALARM_STATUS_OFF);
    setAlarmStatus(AUX_SYSTEM, OIL_LEVEL, ALARM_STATUS_OFF);
    setAlarmStatus(MAIN_SYSTEM, OIL_FILTER, ALARM_STATUS_OFF);
    setAlarmStatus(AUX_SYSTEM, OIL_FILTER, ALARM_STATUS_OFF);
    setAlarmStatus(MAIN_SYSTEM, OIL_TEMP, ALARM_STATUS_OFF);
    setAlarmStatus(AUX_SYSTEM, OIL_TEMP, ALARM_STATUS_OFF);
    setAlarmStatus(GLOBAL_SYSTEM, FU_FAILURE, ALARM_STATUS_OFF);
    showMainPage();
    wait(1); 
    wdt.Service();
    
//    for (int i = 0; i < 2; i++) {
        setPumpInUse(PUMP_IN_USE);
        showMainPage();
        wait(delay); 
        setPumpInUse(PUMP_IN_USE_MAIN);
        showMainPage();
        wait(delay); 
        setPumpInUse(PUMP_IN_USE_AUX);
        showMainPage();
        wait(delay); 
        setPumpInUse(PUMP_OFF);
        showMainPage();
        wait(delay);
//    }

    setPumpRunningStatus(MAIN_SYSTEM, RUN_STATUS_RUNNING);
    showMainPage();
    wait(delay); 
    setPumpRunningStatus(MAIN_SYSTEM, RUN_STATUS_WARNING);
    showMainPage();
    wait(delay); 
    setPumpRunningStatus(MAIN_SYSTEM, RUN_STATUS_DISABLED);
    showMainPage();
    wait(delay); 
    setPumpRunningStatus(MAIN_SYSTEM, RUN_STATUS_OFF_RED);
    showMainPage();
    wait(delay);
    setPumpRunningStatus(MAIN_SYSTEM, RUN_STATUS_OFF);
    showMainPage();
    wait(delay); 
        wdt.Service();

    setPumpRunningStatus(AUX_SYSTEM, RUN_STATUS_RUNNING);
    showMainPage();
    wait(delay); 
    setPumpRunningStatus(AUX_SYSTEM, RUN_STATUS_WARNING);
    showMainPage();
    wait(delay); 
    setPumpRunningStatus(AUX_SYSTEM, RUN_STATUS_DISABLED);
    showMainPage();
    wait(delay); 
    setPumpRunningStatus(AUX_SYSTEM, RUN_STATUS_OFF_RED);
    showMainPage();
    wait(delay);
    setPumpRunningStatus(AUX_SYSTEM, RUN_STATUS_OFF);
    showMainPage();
    wait(delay); 
        wdt.Service();

    setAlarmStatus(MAIN_SYSTEM, PHASE_FAIL, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, PHASE_FAIL, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, PHASE_FAIL, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);

    setAlarmStatus(AUX_SYSTEM, PHASE_FAIL, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, PHASE_FAIL, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, PHASE_FAIL, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    
    setAlarmStatus(MAIN_SYSTEM, MAIN_POWER, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, MAIN_POWER, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, MAIN_POWER, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    wdt.Service();

    setAlarmStatus(AUX_SYSTEM, MAIN_POWER, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, MAIN_POWER, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, MAIN_POWER, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    
    setAlarmStatus(MAIN_SYSTEM, CTRL_POWER, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, CTRL_POWER, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, CTRL_POWER, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
        wdt.Service();

    setAlarmStatus(AUX_SYSTEM, CTRL_POWER, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, CTRL_POWER, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, CTRL_POWER, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    
    setAlarmStatus(MAIN_SYSTEM, OIL_PRESS, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OIL_PRESS, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OIL_PRESS, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);

    setAlarmStatus(AUX_SYSTEM, OIL_PRESS, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OIL_PRESS, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OIL_PRESS, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
        wdt.Service();

    setAlarmStatus(MAIN_SYSTEM, HYDR_LOCK, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, HYDR_LOCK, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, HYDR_LOCK, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);

    setAlarmStatus(AUX_SYSTEM, HYDR_LOCK, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, HYDR_LOCK, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, HYDR_LOCK, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    
    setAlarmStatus(MAIN_SYSTEM, OVERLOAD, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OVERLOAD, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OVERLOAD, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    wdt.Service();

    setAlarmStatus(AUX_SYSTEM, OVERLOAD, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OVERLOAD, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OVERLOAD, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    
    setAlarmStatus(MAIN_SYSTEM, OIL_LEVEL, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OIL_LEVEL, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OIL_LEVEL, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);

    setAlarmStatus(AUX_SYSTEM, OIL_LEVEL, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OIL_LEVEL, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OIL_LEVEL, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
        wdt.Service();

    setAlarmStatus(MAIN_SYSTEM, OIL_FILTER, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OIL_FILTER, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OIL_FILTER, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);

    setAlarmStatus(AUX_SYSTEM, OIL_FILTER, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OIL_FILTER, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OIL_FILTER, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    
    setAlarmStatus(MAIN_SYSTEM, OIL_TEMP, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OIL_TEMP, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(MAIN_SYSTEM, OIL_TEMP, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    wdt.Service();

    setAlarmStatus(AUX_SYSTEM, OIL_TEMP, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OIL_TEMP, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(AUX_SYSTEM, OIL_TEMP, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
    
    setAlarmStatus(GLOBAL_SYSTEM, FU_FAILURE, ALARM_STATUS_WARNING);
    showMainPage();
    wait(delay);
    setAlarmStatus(GLOBAL_SYSTEM, FU_FAILURE, ALARM_STATUS_FAILURE);
    showMainPage();
    wait(delay);
    setAlarmStatus(GLOBAL_SYSTEM, FU_FAILURE, ALARM_STATUS_OFF);
    showMainPage();
    wait(delay);
       wdt.Service();

    restoreAlarms();
    showMainPage();
}
