#ifndef __MAIN_H__
#define __MAIN_H__

#include "FT_Platform.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
//#include "HeapBlockDevice.h"
#include "SPIFBlockDevice.h"
#include "I2CEEBlockDevice.h"
//#include "FRAMSPI.h"
#include "BurstSPI.h"
#include "NMEA0183.h"
#include "nmea_parser.h"
#include "WDT.h"
#include "I2CList.h"
#include "MCP79412.h"

#define WDT_TIMEOUT (float) 20.0

#define BAUD_RATE 9600
// NUCLEO-F746ZG
#define USB_TX          SERIAL_TX   // PD_8  USART3 TX
#define USB_RX          SERIAL_RX   // PD_9  USART3 RX

#define BUFFER_SIZE 8192

//#define BUTTON_ACCEPT_ALARM_TAG 1
//#define BUTTON_ACCEPT_HORN_TAG 2
//#define BUTTON_SET_TAG 3
//#define BUTTON_DIM_TAG 4

#define TFT_MOSI PA_7
#define TFT_MISO PA_6
#define TFT_SCLK PA_5
#define TFT_CS   PC_7
#define TFT_INT  PE_7   // PB_4
#define TFT_PD   PE_8   // PA_4

// Pinout on Nucleo-F746ZG
#define SD_MOSI  PE_14
#define SD_MISO  PE_13
#define SD_SCLK  PE_12
#define SD_CS    PE_11

#define SF_MOSI  PB_15
#define SF_MISO  PC_2
#define SF_SCLK  PB_13
#define SF_CS    PB_12

#define EE_SDA PB_9
#define EE_SCL PB_8
#define EE_ADDR 0xA0
#define EE_SIZE 32*1024
#define EE_BLOCK_SIZE 16

#define MBED_CONF_SD_SPI_TRANSFER_FREQ 40000000



extern Serial pc;
extern WDT wdt;
extern DigitalOut myled;
extern FT813 TFT;
extern SDBlockDevice sd;
extern SPIFBlockDevice spif;
extern I2CEEBlockDevice ee;
extern FATFileSystem fs;
extern NMEA0183 nmea0183;


//Serial pc(USBTX, USBRX);
//DigitalOut myled(LED1);
//FT813 TFT(TFT_MOSI, TFT_MISO, TFT_SCLK, TFT_CS, TFT_INT, TFT_PD);  // mosi, miso, sck, ss, int, pd     // the FT813 is connected to SPI 11-13

#endif
