#include "mbed.h"
#include "rtos.h"
#include "hts221.h"
#include "LPS25H.h"
#include "Data.hpp"
#include "log.hpp"

DigitalOut myled(LED1);
I2C i2c2(I2C_SDA, I2C_SCL);
Mutex mutex_s;

float tempCelsius = 25.50;
float humi = 55;
char cmd=0;
uint32_t seconds = 0, minutes=0, hours=0; 

LPS25H barometer(i2c2, LPS25H_V_CHIP_ADDR);
HTS221 humidity(I2C_SDA, I2C_SCL);


void sensor_init()
{
    humidity.init();
    humidity.calib();
    myled = 0;
}

void sensor_run()
{    
    while (1){
        
        humidity.ReadTempHumi(&tempCelsius, &humi);        
        /*printf("%4.2fC %3.1f%%", tempCelsius, humi);*/        
        barometer.get();        
        /*printf(" %6.1f %4.1f\r\n", barometer.pressure(), barometer.temperature());*/        
        myled = 1; // LED is ON        
        Thread::wait(200); // 200 ms NB 'Thread::wait(int d);' !!! d is in milliseconds!         
        myled = 0; // LED is OFF        
        Thread::wait(100); // 100 ms
    mutex_s.lock();
    Data entry;
    entry.tempCelsius = tempCelsius;
    entry.humi = humi;
    entry.pressure= barometer.pressure();
    entry.logtime = time(0);
    log_push(entry);
    mutex_s.unlock();
    Thread::wait(1000);
    
    }
    
}