#include "Data.hpp"
/* log holds all functions for storing records in circular buffer*/
Data queue_array[120];
int rear = 0;
int front = 0;

Mutex mutex_l;

void log_init()
{

}

/*pushes new record on front of queue*/
void log_push(Data data)
{
    rear = (rear + 1) % 120;
    
    if (rear == front){
        front = (front + 1) % 120;        
    }
    
    queue_array[rear] = data;    
}

/*deletes a record*/
Data log_pop()
{
    Data record;
    if (front != rear)
            {   record = queue_array[rear];             
                rear = (rear + 1) % 120;
            }
        return record;
        
}

/*gets length of array*/
int log_length()
{
    
    int length;
    length = (120 + rear - front) % 120; 
    
    return length;
    
}

/*gets a specific record*/
Data log_get(int index)
{
    
    Data record;
    record = queue_array[(front + index) % 120];
    
    return record;
    
}