#include "mbed.h"
#include "log.hpp"
#include "Data.hpp"

/* prompt deals with all user inputs and what functions should run in response */
Serial serial(USBTX, USBRX);
Mutex mutex_p;

/*function for writing out a record with time struct to format time*/
void prompt_write_entry(Data entry){
            ;
            time_t currenttime = entry.logtime;
            tm* timenew = localtime(&currenttime);
                        
            serial.printf("%4.2fC %3.1f%% %6.1f %i %i %i \r\n", entry.tempCelsius, entry.humi, entry.pressure, timenew->tm_hour, timenew->tm_min, timenew->tm_sec);
            
    }

void readline(char* buffer)
{
    int i = 0;
    while (1) {
        char c = serial.getc();
        serial.putc(c);
        buffer[i] = c;

        if (c == '\n' || c == '\r')
            break;
        else
            i ++;
    }
    buffer[i] = '\0';
}

void prompt_init()
{
    serial.printf("Welcome to the nucleo board low level environmental sensor, type 'help' for commands\r\n");
}



void prompt_interpret(char* cmd)
{
    mutex_p.lock();
    int input;
    int n = log_length();
    int hours;
    int minutes;
    int seconds;
    n = (n - 1);
    if (strcmp(cmd, "help") == 0) {
        serial.printf("Commands:\r\n  help -\r\n READ ALL - Show all records \r\n READ <n> = Show specified amount of records \r\n SETTIME <hh> <mm> <ss> = Set the time \r\n DELETE ALL = Deletes all records \r\n DELETE <n> = deletes the oldest record \r\n ");
    } else if (strcmp(cmd, "READ ALL") == 0) {
        serial.printf("\r\n");
        for (int i = n - 1; i >= 1; i--) {
            Data entry = log_get(i);
            prompt_write_entry(entry);
        }
    } else if (sscanf(cmd, "READ %i", &input) == 1) {
        serial.printf("\r\n");
        
        int n = log_length();
        if (input > n){
            input = n;
            }
        for (int i = input - 1; i >= 1; i--) {
            Data entry = log_get(i);
            prompt_write_entry(entry);
        }
    }
    else if (sscanf(cmd, "SETTIME %i %i %i", &hours, &minutes, &seconds) == 3){
            serial.printf("\r\n");
            time_t currenttime = time(0);
            tm* timenew = localtime(&currenttime);
            
            timenew->tm_hour = hours;
            timenew->tm_min = minutes;
            timenew->tm_sec = seconds;
            
            set_time(mktime(timenew));
        }  
        else if (strcmp(cmd, "DELETE_ALL") == 0) {
        serial.printf("\r\n");
        for (int i = n - 1; i >= 1; i--) {
            log_pop();
            
        }
        }
        else if (sscanf(cmd, "DELETE %i", &input) == 1) {
        serial.printf("\r\n");
        
        int n = log_length();
        if (input > n){
            input = n;
            }
        for (int i = input - 1; i >= 1; i--) {
            log_pop();
             }
    }
    
    else {
        serial.printf("Unknown command!\r\n");
    }
    mutex_p.unlock();
}
void prompt_run()
    {
    while (1) {
        char buffer[64];
        readline(buffer);

        prompt_interpret(buffer);
    }
}