/*sensor.cpp simply reads in the acceleration measurements
using the NUCLEO board and using the function and struct
from buffer.cpp, stores the values in to the circular buffer*/
#include "mbed.h"
#include "x_nucleo_iks01a1.h"
#include "buffer.h"
#include "sensor.h"

Mutex mutex;

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();

extern char *printDouble(char* str, double v, int decimalDigits = 2);

int32_t axes[3];

void sensor_run(){
     while (1) {
          mutex.lock();
    
          accelerometer->Get_X_Axes(axes);

          AccelData d;
          d.x = axes[0];
          d.y = axes[1];
          d.z = axes[2];  
    
          log_push(d);
          mutex.unlock();
    }

}