#include "mbed.h"
#include "C12832.h"
#include "CMPS03.h"
#include "MSCFileSystem.h"
#define FSNAME "msc"

MSCFileSystem msc(FSNAME);

C12832 lcd(p5, p7, p6, p8, p11);
CMPS03 compass(p9, p10, CMPS03_DEFAULT_I2C_ADDRESS);
Serial pc(USBTX, USBRX);
DigitalIn fire(p14);
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

int Time=(300); //time for recording in seconds
int sample=1;   //sample rate in seconds
int j;
int z;

int array[300];

FILE *fp = fopen( "/" FSNAME "/msctest.txt", "w");
int main() {
DIR *d;
struct dirent *p;
d = opendir("/" FSNAME);

while(1){    
    lcd.locate(0,0); //prints to lcd;
    lcd.printf("Power on \nPress buttton to start");
    r=1;
    g=0;
    b=1;
    
    //printf("i got here2");

    if (fire){
        lcd.cls();
        for(int j=0;j<Time;j++){
            
            //set led to orange
            r=0;
            g=0.43;
            b=1;
            
            lcd.locate(0,0);
            lcd.printf("You have been waiting\n %d seconds", (j));
            lcd.locate(0,17);
            lcd.printf("%d", (compass.readBearing()/10));
            array[j]= (compass.readBearing()/10);
            wait(sample);
            
            }       //ends for loop

        for(z=0;z<Time;z++){
            printf("%d\t%d\t\n", z, array[z]);
            fprintf(fp,"%d\t%d\r\n", z, array[z]);

            }
        fclose(fp);
        }           //ends if fire
        

        main();

        
            }       //ends while loop

}                   //ends program


