#ifndef MMA7361L_H
#define MMA7361L_H

#include "mbed.h"
/**accelerometer*/
class MMA7361L {
public:
    /**
    * Creates an MMA7361L accelerometer interface, connected to the specified pins
    * @param xoutPin xout pin
    * @param youtPin yout pin
    * @param zoutPin zout pin
    * @param zeroGDetectPin 0G detect pin
    */
    MMA7361L(PinName xoutPin, PinName youtPin,PinName zoutPin,
             PinName zeroGDetectPin);         
    /**
    * Gets the current total acceleration
    * @returns total acceleration in g
    */          
    float getAccel();
    /** 
    * Gets the current acceleration along the X axis 
    * @returns acceleration along the X axis in g
    */
    float getAccelX();
    /** 
    * Gets the current acceleration along the Y axis 
    * @returns acceleration along the Y axis in g
    */
    float getAccelY();
    /** 
    * Gets the current acceleration along the Z axis 
    * @returns acceleration along the Z axis in g
    */
    float getAccelZ();
    /**
    * Computes the inclination of the X axis
    * @returns the inclination of the X axis
    */
    float getTiltX();
    /**
    * Computes the inclination of the Y axis
    * @returns the inclination of the Y axis
    */    
    float getTiltY();
    /**
    * Computes the inclination of the Z axis
    * @returns the inclination of the Z axis
    */
    float getTiltZ();
    /**
     * Tests whether 0G is detected
     * @returns true if 0G is detected, false otherwise
     */
    bool zeroGDetected();
    /**
    * Sets fucntion to be called when 0G is detected
    * @param func pointer to a function called when 0G is detected, 0 to reset as none
    */ 
    void setZeroGDetectListener(void (*func)(void));
    /**
    * Sets member fucntion to be called when 0G is detected  
    * @param t pointer to the object to call the member function on
    * @param func pointer to the member function tobe called when 0G is detected, 0 to reset as none
    */
    template<typename T> void setZeroGDetectListener(T* t, void (T::*func)(void));

private:
    void prepare();

    AnalogIn xout, yout, zout;
    InterruptIn zeroGDetect;
    float accelX;
    float accelY;
    float accelZ;
    float scaleX;
    float scaleY;
    float scaleZ;
    float Xo;
    float Yo;
    float Zo;
};

#endif