#include "MMA7361L.h"

MMA7361L::MMA7361L(PinName xoutPin, PinName youtPin,PinName zoutPin,
                   PinName zeroGDetectPin) :
        xout(xoutPin), yout(youtPin), zout(zoutPin),
        zeroGDetect(zeroGDetectPin) {
            scaleX = 0.246;
            scaleY = 0.251;
            scaleZ = 0.219;
            Xo = 0.486;
            Yo = 0.520;
            Zo = 0.465;
}

void MMA7361L::prepare(){
    accelX = (xout - Xo) / scaleX;
    accelY = (yout - Yo) / scaleY;
    accelZ = (zout - Zo) / scaleZ;
}

float MMA7361L::getAccel() {
    prepare();
    return sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ);
}

float MMA7361L::getAccelX() {
    prepare();
    return accelX;
}

float MMA7361L::getAccelY() {
    prepare();
    return accelY;
}

float MMA7361L::getAccelZ() {
    prepare();
    return accelZ;
}

float MMA7361L::getTiltX() {
    prepare();
    return asin(accelX / sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ));
}

float MMA7361L::getTiltY() {
    prepare();
    return asin(accelY / sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ));
}

float MMA7361L::getTiltZ() {
    prepare();
    return asin(accelZ / sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ));
}

bool MMA7361L::zeroGDetected() {
    return zeroGDetect;
}

void MMA7361L::setZeroGDetectListener(void (*func)(void)) {
    zeroGDetect.rise(func);
}

template<typename T> void MMA7361L::setZeroGDetectListener(T* t, void (T::*func)(void)) {
    zeroG.rise(t, func);
}
