#include "snsHMC5883L.h"

snsHMC5883L::snsHMC5883L(I2C *_i2c,char _addr7)
{
    addr8 = _addr7<<1;
    pI2C = _i2c;
    init();
    
}

snsHMC5883L::~snsHMC5883L()
{
    
}

void snsHMC5883L::measure(float *_xyz)
{
    char cmd[2];
    char data[8];
    short rawB[3];
    
    cmd[0] = 0x03;
    wait(0.1);
    pI2C->write(addr8, cmd, 1);
    wait(0.1);
    pI2C->read(addr8,data,6);
    rawB[0] = (short)((data[0]<<8) | data[1]);
    rawB[1] = (short)((data[2]<<8) | data[3]);
    rawB[2] = (short)((data[4]<<8) | data[5]);
 
    //order is XZY (not XYZ!)
    _xyz[0] = rawB[0]*gain;
    _xyz[1] = rawB[2]*gain;
    _xyz[2] = rawB[1]*gain;
    
}

void snsHMC5883L::status(char *_st1)
{
    char cmd[2];
    char data[1];
    
    cmd[0] = 0x09;
    wait(0.1);
    pI2C->write(addr8, cmd, 1);
    wait(0.1);
    pI2C->read(addr8,data,1);
    *_st1 = data[0];
    
}

void snsHMC5883L::id(char *_id3)
{
    char cmd[2];
    char data[3];
    
    cmd[0] = 0x0a;
    wait(0.1);
    pI2C->write(addr8, cmd, 1);
    wait(0.1);
    pI2C->read(addr8,data,3);
    _id3[0] = data[0];
    _id3[1] = data[1];
    _id3[2] = data[2];
    
}


void snsHMC5883L::init()
{
    char cmd[2];
    char data[8];

    //config register A
    cmd[0] = 0x00;
    cmd[1] = 0b00010000;
    pI2C->write(addr8, cmd, 2);
    wait(0.1);

    //config register B
    cmd[0] = 0x01;
    cmd[1] = 0b00100000;    //gain 1090 Lsb -> 1 gauss = 100 uT
    gain = 100.0f/1090.0f;
    pI2C->write(addr8, cmd, 2);
    wait(0.1);

    cmd[0] = 0x02;
    cmd[1] = 0b00000000;
    pI2C->write(addr8, cmd, 2);
    wait(0.1);
    
}
