#include "snsCDM7160.h"

snsCDM7160::snsCDM7160(I2C *_i2c,char _addr7)
{
    addr8 = _addr7<<1;
    pI2C = _i2c;
    init();
    
}

snsCDM7160::~snsCDM7160()
{
    
}

void snsCDM7160::measure(int *_co2ppm)
{
    char cmd[2];
    char data[8];
    
    cmd[0] = 0x03;
    wait(0.1);
    pI2C->write(addr8, cmd, 1);
    wait(0.1);
    pI2C->read(addr8,data,2);
    *_co2ppm = (int)((data[1]<<8) | data[0]);

}

void snsCDM7160::status(char *_st1)
{
    char cmd[2];
    char data[1];
    
    cmd[0] = 0x01;
    wait(0.1);
    pI2C->write(addr8, cmd, 1);
    wait(0.1);
    pI2C->read(addr8,data,1);
    *_st1 = data[0];
    
}


void snsCDM7160::init()
{
    char cmd[2];
    char data[8];

    //soft reset
    cmd[0] = 0x00;
    cmd[1] = 0x01;
    pI2C->write(addr8, cmd, 2);

    //check reset
    while(1){
        pI2C->write(addr8,cmd,1);
        wait(0.5);
        pI2C->read(addr8,data,1);
        if(data[0]==0x0){
            break;
        }
    }    

    //set CTL
    cmd[0] = 0x01;
    cmd[1] = 0x06;
    pI2C->write(addr8, cmd, 2);

    
}
