#ifndef __SNSBME280_H__
#define __SNSBME280_H__

#include "mbed.h"

#define BME280_S32_t int
#define BME280_U32_t unsigned int
#define BME280_S64_t signed long long

class snsBME280 {
public:
    snsBME280(I2C *_i2c,char _addr7);
    ~snsBME280();
    void measure(float *_t,float *_p,float *_h);
private:
    char addr8;
    I2C *pI2C;
    unsigned short dig_T1;
    short dig_T2;
    short dig_T3;
    unsigned short dig_P1;
    short dig_P2;
    short dig_P3;
    short dig_P4;
    short dig_P5;
    short dig_P6;
    short dig_P7;
    short dig_P8;
    short dig_P9;
    unsigned char  dig_H1;
    short dig_H2;
    unsigned char dig_H3;
    short dig_H4;
    short dig_H5;
    char  dig_H6;

    BME280_S32_t t_fine;

    void init();
    BME280_S32_t BME280_compensate_T_int32(BME280_S32_t adc_T);
    BME280_U32_t BME280_compensate_P_int64(BME280_S32_t adc_P);
    BME280_U32_t BME280_compensate_H_int32(BME280_S32_t adc_H);
    
};

#endif